package com.corejdo.casestudy.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
/**
 *
 * <BR><FONT Color="red"><B>Trwaa</B></FONT>
 * @author Heiko Bobzin, Keiron McCammon, Sameer Tyagi, Michael Vorburger
 * @version 1.0
 */
public class CD
    extends Publication
{

    List songs = new ArrayList();  // przechowuje obiekty CD.Song
    String referenceNumber;             // nume rreferencyjny pyty CD

    public CD(String referenceNumber)
    {
        this.referenceNumber = referenceNumber;
    }

    private CD()
    {
    }

    public void addSong(String composer, String title, int seconds)
    {
        songs.add(new Song(composer, title, seconds));
    }

    public String songTable()
    {
        StringBuffer buf = new StringBuffer();
        buf.append("<TABLE class=song>\n");
        Iterator iter = songs.iterator();
        while (iter.hasNext()) {
            Song song = (Song)iter.next();
            buf.append("<TR class=song>");
            buf.append("<TD class=songTitle>");
            buf.append(song.title);
            buf.append("</TD>");
            buf.append("<TD class=songComposer>");
            buf.append(song.composer);
            buf.append("</TD>");
            buf.append("<TD class=songLength>");
            buf.append(song.length());
            buf.append("</TD>");
            buf.append("</TR>");
        }
        buf.append("</TABLE>\n");
        return buf.toString();
    }

    public String toString()
    {
        StringBuffer buf = new StringBuffer();
        buf.append("CD: ");
        buf.append(this.referenceNumber);
        buf.append(super.toString());
        Iterator iter = songs.iterator();
        while (iter.hasNext()) {
            Song song = (Song)iter.next();
            buf.append(song);
            buf.append(", ");
        }
        return buf.toString();
    }

    public String toHTML(String linkPrefix)
    {
        return "<TR CLASS=CD>"+toHTMLTitle(linkPrefix)+
          "<TD VALIGN=TOP>"+songTable()+"</TD>"+
          "<TD VALIGN=TOP></TD>"+
          super.toHTMLRest(linkPrefix)+"</TR>";
    }
}
