/* $Id$ */
/* Copyright R 2002 George Reese, Imaginet */
package org.dasein.persist;

// Opracowa  George Reese dla potrzeb ksiki:
// Java. Aplikacje bazodanowe. Najlepsze rozwizania: J2EE
// Przenis na bibliotek kodu digital@jwt George Reese

/**
 * Reprezentuje bd dostpu do rda danych. Klasa ta
 * w zasadzie zawiera implementacj wyjtku rda danych,
 * ktry wyjania prawdziw natur bdu. * <br/>
 * Ostatnia modyfikacja $Date$
 * @wersja $Revision$
 * @autor George Reese
 */
public class PersistenceException extends Exception {
    /**
     * Wyjtek, ktry doprowadzi do tego problemu z utrwalaniem.
     */
    private Exception cause = null;

    /**
     * Tworzy nowy wyjtek utrwalania, ktry pojawi si
     * z nieznanego dotychczas powodu.
     */
    public PersistenceException() {
        super();
    }

    /**
     * Tworzy nowy wyjtek utrwalania z okrelonym
     * objanieniem.
     * @parametr msg objanienie bdu
     */
    public PersistenceException(String msg) {
        super(msg);
    }

    /**
     * Tworzy nowy wyjtek utrwalania wynikajcy z
     * okrelonego wyjtku zwizanego z magazynem danych.
     * @parametr cse powd wyjtku utrwalania
     */
    public PersistenceException(Exception cse) {
        super(cse.getMessage());
        cause = cse;
    }

    /**
     * @zwraca przyczyn wyjtku
     */
    public Exception getCause() {
        return cause;
    }
}
