package org.dasein.gb.persist;

import java.sql.SQLException;
import java.util.HashMap;

import org.dasein.gb.Comment;
import org.dasein.persist.Execution;
import org.dasein.persist.PersistenceException;

public class RemoveComment extends Execution {
    static public RemoveComment getInstance() {
        return (RemoveComment)Execution.getInstance(RemoveComment.class);
    }
    
    static private final String DELETE =
        "DELETE FROM Comment WHERE commentID = ?";

    static private final int COMMENT_ID  = 1;
    
    public HashMap run() throws PersistenceException, SQLException {
        long cid = ((Long)data.get(Comment.COMMENT_ID)).longValue();

        statement.setLong(COMMENT_ID, cid);
        if( statement.executeUpdate() != 1 ) {
            throw new PersistenceException("Usunito podejrzanie duo wierszy.");
        }
        return null;
    }

    public String getDataSource() {
        return "jdbc/kyra";
    }
    
    public String getStatement() {
        return DELETE;
    }
}
