package org.dasein.gb.persist;

import java.util.ArrayList;
import java.util.HashMap;

import org.dasein.gb.Comment;
import org.dasein.persist.Execution;
import org.dasein.persist.PersistenceException;

public abstract class CommentDAO {
    static public void create(HashMap data) throws PersistenceException {
        CreateComment.getInstance().execute(data);
    }

    static public ArrayList getApproved() throws PersistenceException {
        HashMap data = new HashMap();

        data.put(Comment.APPROVED, new Boolean(true));
        data = ListComments.getInstance().execute(data);
        return (ArrayList)data.get(ListComments.COMMENTS);
    }
    
    static public HashMap getComment(long cid) throws PersistenceException {
        HashMap data = new HashMap();

        data.put(Comment.COMMENT_ID, new Long(cid));
        data = LoadComment.getInstance().execute(data);
        return data;
    }

    static public ArrayList getPending() throws PersistenceException {
        HashMap data = new HashMap();

        data.put(Comment.APPROVED, new Boolean(false));
        data = ListComments.getInstance().execute(data);
        return (ArrayList)data.get(ListComments.COMMENTS);
    }
    
    static public void save(HashMap data) throws PersistenceException {
        SaveComment.getInstance().execute(data);
    }
    
    static public void remove(HashMap data) throws PersistenceException {
        RemoveComment.getInstance().execute(data);
    }
}
