package org.dasein.util;

// importy Javy
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

/**
 * <p class="text">
 * Bufor dla obiektw, ktrego zawarto traci wano jeeli
 * nie s wykorzystywane. W buforze uyto kodu
 * <span class="code">java.lang.ref.SoftReference</span> w celu zagwarantowania,
 * e pozycje zostan usunite z bufora, jeeli nie bd 
 * wywoywane przez duszy czas. 
 * </p>
 * <p class="text">
 * Ta klasa nie jest synchronizowana i dlatego dla wykorzystania wielowtkowego, powinna 
 * by zsynchronizowana przez aplikacj.
 * </p>
 * @modyfikacja $Date$
 * @wersja $Revision$
 * @autor George Reese/george.reese@jwt.com
 */
public class Cache implements Collection, Serializable {
    /**
     * Konstrukcja hash map indeksujca odwoania za pomoc niepowtarzalnych kluczy.
     */
    private HashMap cache = new HashMap();

    /*
     * Utworzenie nowego, pustego bufora.
     */
    public Cache() {
        super();
    }

    /**
     * Nieobsugiwana.
     * @parametr ob zignorowany
     * @zwraca nie zwraca adnych wartoci
     * @zgasza wyjtek java.lang.UnsupportedOperationException zawsze
     */
    public boolean add(Object ob) {
        throw new UnsupportedOperationException();
    }
    
    /**
     * Nieobsugiwana.
     * @parametr coll zignorowany
     * @return  nie zwraca adnych wartoci
     * @zgasza java.lang.UnsupportedOperationException zawsze
     */
    public boolean addAll(Collection coll) {
        throw new UnsupportedOperationException();
    }
    
    /**
     * Buforuje okrelony obiekt identyfikowany przez podany klucz.
     * @parametr key niepowtarzalny klucz obiektu
     * @parametr val obiekt do umieszczenia w buforze
     */
    public void cache(Object key, Object val) {
        cache.put(key, new SoftReference(val));
    }

    /**
     * Wyzerowanie caego bufora.
     */
    public void clear() {
        cache.clear();
    }
    
    /**
     * Sprawdzenie okrelonego obiektu z buforem i sprawdzenie, czy      
     * znajduje si w buforze. Metoda zwraca warto
     * <span class="keyword">false</span> jeeli obiekt znajdowa si w buforze,
     * ale straci wano ze wzgldu na brak wykorzystania.
     * @parametr ob obiekt do sprawdzenia w buforze
     * @zwraca true jeeli obiekt jest w buforze
     */
    public boolean contains(Object ob) {
        Iterator it = cache.values().iterator();

        while( it.hasNext() ) {
            SoftReference ref = (SoftReference)it.next();
            Object item = ref.get();

            if( item != null && ob.equals(item) ) {
                return true;
            }
        }
        return false;
    }
    
    /**
     * Sprawdza przekazan kolekcj i okrela, czy wszystkie elementy
     * tej kolekcji znajduj si w buforze. Naley zachowa ostrono     
     * poniewa zbyt dugi odczyt powoduje awari. Jeeli jeden z elementw
     * by kiedy w buforze, ale straci wano ze wzgldu na brak wykorzystania, wwczas
     * ta metoda zwrci warto false.
     * @parametr coll kolekcja do sprawdzenia
     * @zwraca true jeeli wszystkie elementy sprawdzanej kolekcji s w buforze
     */
    public boolean containsAll(Collection coll) {
        Iterator it = coll.iterator();

        while( it.hasNext() ) {
            if( !contains(it.next()) ) {
                return false;
            }
        }
        return true;
    }
    
    /**
     * Sprawdza, czy obiekt o okrelonym kluczu znajduje si w buforze.
     * @parametr key identyfikator obiektu
     * @zwraca true jeeli obiekt znajduje si w buforze
     */
    public boolean containsKey(Object key) {
        if( !cache.containsKey(key) ) {
            return false;
        }
        else {
            SoftReference ref = (SoftReference)cache.get(key);

            if( ref.get() == null ) {
                release(key);
                return false;
            }
            return true;
        }
    }

    /**
     * Udostpnia obiekt z bufora identyfikowany przez okrelony klucz. Metoda zwraca
     * <span class="code">null</span> jeeli okrelonego obiektu
     * nie ma w buforze.
     * @parametr key niepowtarzalny identyfikator danego obiektu
     * @zwraca obiekt z bufora lub null
     */
    public Object get(Object key) {
        SoftReference ref = (SoftReference)cache.get(key);
        Object ob;

        if( ref == null ) {
            return null;
        }
        ob = ref.get();
        if( ob == null ) {
            release(key);
        }
        return ob;
    }

    /**
     * @zwraca true jezeli bufor jest pusty
     */
    public boolean isEmpty() {
        return cache.isEmpty();
    }

    /**
     * Udostpnia wszystkie poprawne obiekty z bufora.
     * Metoda ta moe dziaa do wolno.
     * @zwraca wszystkie poprawne obiekty w buforze
     */
    public Iterator iterator() {
        return toList().iterator();
    }
    
    /**
     * Zwalnia okrelony obiekt z bufora.
     * @parametr key niepowtarzalny klucz identyfikujcy pozycj do zwolnienia
     */
    public void release(Object key) {
        cache.remove(key);
    }

    /**
     * Nieobsugiwana.
     * @parametr ob zignorowany
     * @zwraca nic nie zwraca
     * @zgasza java.lang.UnsupportedOperationException zawsze
     */
    public boolean remove(Object ob) {
        throw new UnsupportedOperationException();
    }

    /**
     * Nieobsugiwana
     * @parametr coll zignorowany
     * @zwraca nic nie zwraca
     * @zgasza java.lang.UnsupportedOperationException zawsze
     */
    public boolean removeAll(Collection coll) {
        throw new UnsupportedOperationException();
    }

    /**
     * Unsupported.
     * @parametr coll zignorowany
     * @zwraca nic nie zwraca
     * @zgasza java.lang.UnsupportedOperationException zawsze
     */
    public boolean retainAll(Collection coll) {
        throw new UnsupportedOperationException();
    }

    /**
     * @zwraca liczb elementw w buforze
     */
    public int size() {
        return toList().size();
    }

    /**
     * @zwraca bufor w postaci tablicy
     */
    public Object[] toArray() {
        return toList().toArray();
    }

    /**
     * @zwraca bufor w postaci tablicy
     */
    public Object[] toArray(Object[] arr) {
        return toList().toArray(arr);
    }

    /**
     * @zwraca bufor w postaci tablicy
     */
    private ArrayList toList() {
        Iterator it = cache.values().iterator();
        ArrayList tmp = new ArrayList();

        while( it.hasNext() ) {
            SoftReference ref = (SoftReference)it.next();
            Object ob = ref.get();
            
            if( ob != null ) {
                tmp.add(ob);
            }
        }
        return tmp;
    }
}
