package org.dasein.security;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

import org.dasein.persist.PersistenceException;

public abstract class UserDAO {
    static private final String AUTH =
        "SELECT userID FROM User WHERE userID = ? AND passwd = PASSWORD(?)";
    static private final int A_UID = 1;
    static private final int A_PW  = 2;
    
    static void authenticate(String uid, String pw)
        throws AuthenticationException, PersistenceException {
        PreparedStatement stmt = null;
        Connection conn = null;
        ResultSet rs = null;
        
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup("jdbc/kyra");
            
            conn = ds.getConnection();
            stmt = conn.prepareStatement(AUTH);
            stmt.setString(A_UID, uid);
            stmt.setString(A_PW, pw);
            rs = stmt.executeQuery();
            if( !rs.next() ) {
                throw new AuthenticationException("Nieprawidowe ID lub haso.");
            }
        }
        catch( NamingException e ) {
            throw new PersistenceException(e);
        }
        catch( SQLException e ) {
            throw new PersistenceException(e);
        }
        finally {
            if( rs != null ) {
                try { rs.close(); }
                catch( SQLException e ) { }
            }
            if( stmt != null ) {
                try { stmt.close(); }
                catch( SQLException e ) { }
            }
            if( conn != null ) {
                try { conn.close(); }
                catch( SQLException e ) { }
            }
        }
    }

    static private final String CPW =
        "UPDATE User SET passwd = ? WHERE userID = ? AND passwd = ?";
    static private final int C_NPW = 1;
    static private final int C_UID = 2;
    static private final int C_OPW = 3;
    
    static boolean changePassword(String uid, String opw, String npw)
        throws PersistenceException {
        PreparedStatement stmt = null;
        Connection conn = null;
        
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup("jdbc/kyra");
            
            conn = ds.getConnection();
            stmt = conn.prepareStatement(CPW);
            stmt.setString(C_NPW, npw);
            stmt.setString(C_UID, uid);
            stmt.setString(C_OPW, opw);
            return (stmt.executeUpdate() == 1);
        }
        catch( NamingException e ) {
            throw new PersistenceException(e);
        }
        catch( SQLException e ) {
            throw new PersistenceException(e);
        }
        finally {
            if( stmt != null ) {
                try { stmt.close(); }
                catch( SQLException e ) { }
            }
            if( conn != null ) {
                try { conn.close(); }
                catch( SQLException e ) { }
            }
        }        
    }

    static private final String LOAD =
        "SELECT userID, authorization, email, firstName, lastName, " +
        "nickname, webPage " +
        "FROM User " +
        "WHERE userID = ?";
    static private final int L_UID        = 1;
    static private final int L_AUTH       = 2;
    static private final int L_EMAIL      = 3;
    static private final int L_FIRST_NAME = 4;
    static private final int L_LAST_NAME  = 5;
    static private final int L_NICKNAME   = 6;
    static private final int L_WEB_PAGE   = 7;
    
    static HashMap load(String uid) throws PersistenceException {
        PreparedStatement stmt = null;
        Connection conn = null;
        ResultSet rs = null;
        
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup("jdbc/kyra");
            HashMap data = new HashMap();
            String tmp;
            
            conn = ds.getConnection();
            stmt = conn.prepareStatement(LOAD);
            stmt.setString(L_UID, uid);
            rs = stmt.executeQuery();
            if( !rs.next() ) {
                throw new PersistenceException("Nie ma takiego uytkownika.");
            }
            data.put(SharedUser.AUTHORIZATION, new Integer(rs.getInt(L_AUTH)));
            data.put(SharedUser.EMAIL, rs.getString(L_EMAIL).trim());
            data.put(SharedUser.FIRST_NAME, rs.getString(L_FIRST_NAME).trim());
            data.put(SharedUser.LAST_NAME, rs.getString(L_LAST_NAME).trim());
            data.put(SharedUser.NICKNAME, rs.getString(L_NICKNAME).trim());
            tmp = rs.getString(L_WEB_PAGE);
            if( rs.wasNull() ) {
                data.put(SharedUser.WEB_PAGE, null);
            }
            else {
                data.put(SharedUser.WEB_PAGE, tmp.trim());
            }
            return data;
        }
        catch( NamingException e ) {
            throw new PersistenceException(e);
        }
        catch( SQLException e ) {
            throw new PersistenceException(e);
        }
        finally {
            if( rs != null ) {
                try { rs.close(); }
                catch( SQLException e ) { }
            }
            if( stmt != null ) {
                try { stmt.close(); }
                catch( SQLException e ) { }
            }
            if( conn != null ) {
                try { conn.close(); }
                catch( SQLException e ) { }
            }
        }
    }

    static void logout(String uid) {
    }
}
