package org.dasein.gb.persist;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Types;
import java.util.HashMap;

import org.dasein.gb.Comment;
import org.dasein.persist.Execution;
import org.dasein.persist.PersistenceException;

public class CreateComment extends Execution {
    static public CreateComment getInstance() {
        return (CreateComment)Execution.getInstance(CreateComment.class);
    }
    
    static private final String CREATE =
        "INSERT INTO Comment ( commentID, created, approved, email, name, " +
        "comment ) " +
        "VALUES ( ?, ?, ?, ?, ?, ? )";

    static private final int COMMENT_ID   = 1;
    static private final int CREATED      = 2;
    static private final int APPROVED     = 3;
    static private final int EMAIL        = 4;
    static private final int NAME         = 5;
    static private final int COMMENT      = 6;
    
    public HashMap run() throws PersistenceException, SQLException {
        Date now = new Date(System.currentTimeMillis());
        String tmp;
        Long val;

        val = (Long)data.get(Comment.COMMENT_ID);
        statement.setLong(COMMENT_ID, val.longValue());
        statement.setDate(CREATED, now);
        statement.setString(APPROVED, "N");
        tmp = (String)data.get(Comment.EMAIL);
        if( tmp == null ) {
            statement.setNull(EMAIL, Types.VARCHAR);
        }
        else {
            statement.setString(EMAIL, tmp);
        }
        statement.setString(NAME, (String)data.get(Comment.NAME));
        statement.setString(COMMENT, (String)data.get(Comment.COMMENT));
        statement.executeUpdate();
        data.put(Comment.CREATED, now);
        return null;
    }

    public String getDataSource() {
        return "jdbc/kyra";
    }
    
    public String getStatement() {
        return CREATE;
    }
}
