package org.dasein.security;

import java.io.Serializable;
import java.util.Locale;

import org.dasein.persist.PersistenceException;

public class User implements Serializable {
    static public final String USER_ID       = "userID";

    private Locale  locale        = null;
    private String  userID        = null;
    
    public User() {
        super();
    }

    public synchronized boolean authenticate(String uid, String pw)
        throws PersistenceException {
        if( isAuthenticated() ) {
            logout();
        }
        try {
            SharedUser u = SharedUser.getUser(uid);

            u.authenticate(pw);
            userID = uid;
            return true;
        }
        catch( AuthenticationException e ) {
            return false;
        }
    }

    public synchronized boolean authorize(int prot)
        throws PersistenceException {
        return (getAuthorization() >= prot);
    }
    
    public synchronized boolean changePassword(String opw, String npw)
    throws PersistenceException {
        if( !isAuthenticated() ) {
            return false;
        }
        return getSharedUser().changePassword(opw, npw);
    }

    public synchronized int getAuthorization() throws PersistenceException {
        if( !isAuthenticated() ) {
            return 0;
        }
        return getSharedUser().getAuthorization();
    }

    public synchronized String getEmail() throws PersistenceException {
        if( !isAuthenticated() ) {
            return null;
        }
        return getSharedUser().getEmail();
    }

    public synchronized String getFirstName() throws PersistenceException {
        if( !isAuthenticated() ) {
            return null;
        }
        return getSharedUser().getFirstName();
    }

    public synchronized String getLastName() throws PersistenceException {
        if( !isAuthenticated() ) {
            return null;
        }
        return getSharedUser().getLastName();
    }

    public synchronized Locale getLocale() throws PersistenceException {
        Locale loc = getSharedUser().getLocale();

        if( loc == null ) {
            loc = locale;
            if( loc == null ) {
                loc = Locale.getDefault();
            }
        }
        return loc;
    }
    
    public synchronized String getNickname() throws PersistenceException {
        if( !isAuthenticated() ) {
            return null;
        }
        return getSharedUser().getNickname();
    }

    private SharedUser getSharedUser() throws PersistenceException {
        if( !isAuthenticated() ) {
            return null;
        }
        return SharedUser.getUser(userID);
    }
    
    public synchronized String getUserID() {
        return userID;
    }

    public synchronized String getWebPage() throws PersistenceException {
        if( !isAuthenticated() ) {
            return null;
        }
        return getSharedUser().getWebPage();
    }
    
    public synchronized boolean isAuthenticated() {
        return (userID != null);
    }

    public synchronized void logout() {
        if( !isAuthenticated() ) {
            return;
        }
        try {
            getSharedUser().logout();
        }
        catch( PersistenceException e ) {
            // to nie powinno si zdarzy
            e.printStackTrace();
        }
        userID = null;
    }

    public synchronized void setLocale(Locale loc) {
        locale = loc;
    }
}
