package org.dasein.gb.persist;

import java.sql.SQLException;
import java.sql.Types;
import java.util.HashMap;

import org.dasein.gb.Comment;
import org.dasein.persist.Execution;
import org.dasein.persist.PersistenceException;

public class SaveComment extends Execution {
    static public SaveComment getInstance() {
        return (SaveComment)Execution.getInstance(SaveComment.class);
    }
    
    static private final String SAVE =
        "UPDATE Comment " +
        "SET approved = ?, " +
        "email = ?, " +
        "name = ?, " +
        "comment = ? " +
        "WHERE commentID = ?";

    static private final int APPROVED    = 1;
    static private final int EMAIL       = 2;
    static private final int NAME        = 3;
    static private final int COMMENT     = 4;
    static private final int COMMENT_ID  = 5;
    
    public HashMap run() throws PersistenceException, SQLException {
        long cid = ((Long)data.get(Comment.COMMENT_ID)).longValue();
        String tmp;
        boolean b;

        b = ((Boolean)data.get(Comment.APPROVED)).booleanValue();
        statement.setString(APPROVED, (b ? "T" : "N"));
        tmp = (String)data.get(Comment.EMAIL);
        if( tmp == null ) {
            statement.setNull(EMAIL, Types.VARCHAR);
        }
        else {
            statement.setString(EMAIL, tmp);
        }
        statement.setString(NAME, (String)data.get(Comment.NAME));
        statement.setString(COMMENT, (String)data.get(Comment.COMMENT));
        statement.setLong(COMMENT_ID, cid);
        if( statement.executeUpdate() != 1 ) {
            throw new PersistenceException("Uaktualniono podejrzan liczb wierszy.");
        }
        return null;
    }

    public String getDataSource() {
        return "jdbc/kyra";
    }
    
    public String getStatement() {
        return SAVE;
    }
}
