package org.dasein.gb.persist;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

import org.dasein.gb.Comment;
import org.dasein.persist.Execution;
import org.dasein.persist.PersistenceException;

public class ListComments extends Execution {
    static public final String COMMENTS = "comments";
    
    static public ListComments getInstance() {
        return (ListComments)Execution.getInstance(ListComments.class);
    }
    
    static private final String LOAD =
        "SELECT commentID " +
        "FROM Comment " +
        "WHERE approved = ? " +
        "ORDER BY created DESC";

    static private final int APPROVED     = 1;
    
    static private final int COMMENT_ID   = 1;
    
    public HashMap run() throws PersistenceException, SQLException {
        boolean app = ((Boolean)data.get(Comment.APPROVED)).booleanValue();
        ArrayList cmts = new ArrayList();
        HashMap res = new HashMap();

        res.put(COMMENTS, cmts);
        statement.setString(APPROVED, (app ? "T" : "N"));
        results = statement.executeQuery();
        while( results.next() ) {
            Long cid = new Long(results.getLong(COMMENT_ID));

            cmts.add(cid);
        }
        return res;
    }

    public String getDataSource() {
        return "jdbc/kyra";
    }

    public String getStatement() {
        return LOAD;
    }
}
