package pl.helion.j2mepp.zdalnakamera;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.*;
import pl.helion.j2mepp.zdalnakamera.dodatkowe.NadawcaObrazTask;
import pl.helion.j2mepp.zdalnakamera.dodatkowe.ObrazTask;
import pl.helion.j2mepp.zdalnakamera.dodatkowe.OdbiorcaObrazTask;
import pl.helion.j2mepp.zdalnakamera.komunikacja.HttpMenedzerObrazow;
import pl.helion.j2mepp.zdalnakamera.komunikacja.MenedzerObrazow;

public class ZdalnaKameraMIDlet extends MIDlet {

    private static String SERVER_URL = "http://localhost:8080/ZdalnaKameraSerwer/ZdalnaKameraSerwlet";

    private LogowanieForm logowanie;
    private ObrazForm obraz;
    private Display wyswietlacz = Display.getDisplay(this);
    private MenedzerObrazow menedzerObraz = new HttpMenedzerObrazow();

    public ZdalnaKameraMIDlet() {
        this.logowanie = new LogowanieForm(new LogowanieFormCommandListener());
        this.obraz = new ObrazForm(new ObrazFormCommandListener());
        menedzerObraz.init(SERVER_URL);
        wyswietlacz.setCurrent(logowanie);
    }

    public void startApp() {
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }

    public Alert generujInfo(String tytul, String komunikat) {
        Alert a = new Alert(tytul);
        a.setString(komunikat);
        return a;
    }

    public void uruchom(boolean nadawca) {
        wyswietlacz.setCurrent(obraz);
        ObrazTask zadanie = null;
        if (nadawca)
            zadanie = new NadawcaObrazTask(menedzerObraz);
        else
            zadanie = new OdbiorcaObrazTask(menedzerObraz);
        obraz.start(zadanie);
    }

    class LogowanieFormCommandListener implements CommandListener {
        public void commandAction(Command c, Displayable d) {
            switch (c.getCommandType()) {
                case Command.OK:
                    if (logowanie.isNadawca()) {
                        String SID = menedzerObraz.generujSID();
                        if (obraz.ustawKamere()) {
                            obraz.setSID(SID);
                            uruchom(true);
                        } else
                            wyswietlacz.setCurrent(generujInfo("Błąd!", "Nie udało się zainicjalizować kamery!"));
                    } else
                    {
                        String SID = logowanie.getSID();
                        menedzerObraz.setSID(SID);
                        uruchom(false);
                    }
                    break;
            }
        }
    }

    class ObrazFormCommandListener implements CommandListener {
        public void commandAction(Command c, Displayable d) {
            if (logowanie.isNadawca())
                menedzerObraz.wyloguj();
            notifyDestroyed();
        }
    }
}
