package pl.helion.j2mepp.graplatformowa;

import java.io.DataInputStream;
public class MenadzerDanych
{
 public MenadzerDanych(String nazwa) throws Exception
 {
  wej = new DataInputStream(this.getClass().getResourceAsStream(nazwa)); //1
  pozycjax = wej.readShort();
  pozycjay = wej.readShort();
  xkoniec = wej.readShort();
  ykoniec = wej.readShort();
  szerokosc = wej.readShort();
  wysokosc = wej.readShort();
  duzex = wej.readShort();
  duzey = wej.readShort();
  planszax = wej.readShort();
  planszay = wej.readShort();
  startplanszax = wej.readShort();
  startplanszay = wej.readShort();
  short[] params = new short[duzex*duzey];
  for (int i=0;i<params.length;i++)
   params[i] = wej.readShort();
  plansza = new short[duzex][duzey];
  for (int i=0;i<duzey;i++)
   for (int j=0;j<duzex;j++)
   {
    plansza[j][i] = params[i*duzex+j];
   }
  short ilosc = wej.readShort();
  dane = new DanePotworka[planszax][planszay][];
  dlugosciDanych = new short[planszax][planszay]; // ilosc potworkow w danej komorce
  DanePotworka[] tymczasowe = new DanePotworka[ilosc]; // lista wszystkich potworkow
  params = new short[6*ilosc];
  for (int i=0;i<params.length;i++)
   params[i] = wej.readShort();
  for (int i=0;i<ilosc;i++) // wczytywanie potworkow
  {
   tymczasowe[i] = new DanePotworka(params[i*6],params[i*6+1],params[i*6+2],(params[i*6+3]>0?true:false),params[i*6+4],params[i*6+5]);
   dlugosciDanych[params[i*6+4]-1][params[i*6+5]-1] += 1;
  }
  for (int i=0;i<planszay;i++) 
   for (int j=0;j<planszax;j++)
    dane[j][i] = new DanePotworka[dlugosciDanych[j][i]];//tworzenie list potworkow w kazdej komorce
  dlugosciDanych = new short[planszax][planszay];//NOWY SPOSOB WYKORZYSTANIA - AKTUALNA ILOSC ELEMENT�W
  for (int i=0;i<tymczasowe.length;i++)
  {
   int tempx = tymczasowe[i].getPlanszaX()-1;
   int tempy = tymczasowe[i].getPlanszaY()-1;
   dane[tempx][tempy][dlugosciDanych[tempx][tempy]] = tymczasowe[i]; // kopiowanie potworka do wlasciwej komorki
   dlugosciDanych[tempx][tempy] += 1; // zmiana aktualnej liczby potworkow w danej kom�rce
  }
  wej.close();
 }
 public short getXKoncowe()
 {
  return xkoniec;
 }
 public short getYKoncowe()
 {
  return ykoniec;
 }
 public short getSzerokosc()
 {
  return szerokosc;
 }
 public short getWysokosc()
 {
  return wysokosc;
 }
 public short getPozycjaX()
 {
  return pozycjax;
 }
 public short getPozycjaY()
 {
  return pozycjay;
 }
 public short getPlanszaX()
 {
  return planszax;
 }
 public short getPlanszaY()
 {
  return planszay;
 }
 public short getDuzeX()
 {
  return duzex;
 }
 public short getDuzeY()
 {
  return duzey;
 }
 public short getStartPlanszaX()
 {
  return startplanszax;
 }
 public short getStartPlanszaY()
 {
  return startplanszay;
 }
 public short[][] getPlansza()
 {
  return plansza;
 }
 public DanePotworka[][][] getDane()
 {
  return dane;
 }
 private DataInputStream wej;
 private short xkoniec;
 private short ykoniec;
 private short szerokosc;
 private short wysokosc;
 private short pozycjax;
 private short pozycjay;
 private short planszax;
 private short planszay;
 private short duzex;
 private short duzey;
 private short startplanszax;
 private short startplanszay;
 private short[][] plansza;
 private short[][] dlugosciDanych;
 private DanePotworka[][][] dane;
}