package pl.helion.j2mepp.programgraficzny;

import javax.microedition.lcdui.*;
import java.util.Vector;
public class Plotno extends Canvas 
{
	public Plotno()
	{
		bufor = Image.createImage(this.getWidth(), this.getHeight());
		bg = bufor.getGraphics();
		x = this.getWidth() / 2;
		y = this.getHeight() / 2;
		punkty = new Vector();
		typ = "prostokat";
	}
	protected void paint(Graphics g)
	{
		g.setColor(255,255,255);
		g.fillRect(0,0,this.getWidth(),this.getHeight());
		g.drawImage(bufor,0,0,Graphics.TOP|Graphics.LEFT);
		g.setColor(this.r,this.g,this.b);
		g.drawLine(x,y,x,y);
	}
	protected void keyPressed(int klawisz)
	{
		if (klawisz == Canvas.KEY_NUM2)
			this.ruszaj(0,-1);
		if (klawisz == Canvas.KEY_NUM4)
			this.ruszaj(-1,0);
		if (klawisz == Canvas.KEY_NUM6)
			this.ruszaj(1,0);
		if (klawisz == Canvas.KEY_NUM8)
			this.ruszaj(0,1);
		if (klawisz == Canvas.KEY_NUM1)
			this.ruszaj(-1,-1);
		if (klawisz == Canvas.KEY_NUM3)
			this.ruszaj(1,-1);
		if (klawisz == Canvas.KEY_NUM7)
			this.ruszaj(-1,1);
		if (klawisz == Canvas.KEY_NUM9)
			this.ruszaj(1,1);
	}
	protected void keyRepeated(int klawisz)
	{
		this.keyPressed(klawisz);
	}
	private void ruszaj(int dx, int dy)
	{
		if (x+dx>0 && x+dx<this.getWidth() && y+dy>0 && y+dy<this.getHeight())
		{
			x += dx;
			y += dy;
		}
		this.repaint();
	}
	private int[] zwrocProstokat(Object o1, Object o2)
	{
		int[] p1 = (int[])o1;
		int[] p2 = (int[])o2;
		int[] wynik1 = new int[]{Math.min(p1[0],p2[0]),Math.min(p1[1],p2[1])};
		int[] wynik2 = new int[]{Math.max(p1[0],p2[0]),Math.max(p1[1],p2[1])};
		int dlugosc = Math.abs(wynik2[0] - wynik1[0]);
		int wysokosc = Math.abs(wynik2[1] - wynik1[1]);
		return new int[] {wynik1[0], wynik1[1], dlugosc, wysokosc};
	}
	public void ustawFigure(String figura)
	{
		typ = figura;
		punkty.removeAllElements();
	}
	public void ustawKolor(int _r, int _g, int _b)
	{
		r = _r;
		g = _g;
		b = _b;
	}
	public void zaznacz()
	{
		punkty.addElement(new int[]{x, y});
		if (punkty.size() == 2 && typ.equals("prostokat"))
		{
			int[] wartosci = this.zwrocProstokat(punkty.elementAt(0),punkty.elementAt(1));
			bg.setColor(r,g,b);
			bg.drawRect(wartosci[0],wartosci[1],wartosci[2],wartosci[3]);
			punkty.removeAllElements();
		}
		if (punkty.size() == 2 && typ.equals("linia"))
		{
			int[] p1 = (int[])punkty.elementAt(0);
			int[] p2 = (int[])punkty.elementAt(1);
			bg.setColor(r,g,b);
			bg.drawLine(p1[0],p1[1],p2[0],p2[1]);
			punkty.removeAllElements();
		}
		if (punkty.size() == 3 && typ.equals("trojkat"))
		{
			int[] p1 = (int[])punkty.elementAt(0);
			int[] p2 = (int[])punkty.elementAt(1);
			int[] p3 = (int[])punkty.elementAt(2);
			bg.setColor(r,g,b);
			bg.fillTriangle(p1[0],p1[1],p2[0],p2[1],p3[0],p3[1]);
			punkty.removeAllElements();
		}
		this.repaint();
	}
	private Graphics bg;
	private Image bufor;
	private int x;
	private int y;
	private int r;
	private int g;
	private int b;
	private Vector punkty;
	private String typ;
}
