package pl.helion.j2mepp.lokalizator;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import pl.helion.j2mepp.lokalizator.dto.Uzytkownik;

public class WyszukiwarkaForm extends Form {
    private TextField txtLogin = new TextField("Wprowadź login:", "", 100, TextField.ANY);
    private StringItem btnSzukaj = new StringItem("", "Szukaj", StringItem.BUTTON);
    private StringItem lblStatus = new StringItem("", "", StringItem.PLAIN);
    private StringItem lblZnaleziony = new StringItem("", "", StringItem.PLAIN);

    private Command cmdSzukaj = new Command("Szukaj", Command.OK, 0);
    private Command cmdDodaj = new Command("Dodaj", Command.OK, 1);
    private Command cmdPowrot = new Command("Powrót", Command.BACK, 0);

    private Uzytkownik znaleziony;

    public WyszukiwarkaForm(CommandListener l) {
        super("Wyszukiwarka");
        btnSzukaj.setDefaultCommand(cmdSzukaj);
        this.append(txtLogin);
        this.append(lblStatus);
        this.append(lblZnaleziony);
        this.addCommand(cmdSzukaj);
        this.addCommand(cmdDodaj);
        this.addCommand(cmdPowrot);
        this.setCommandListener(l);
    }

    public String getLogin() {
        return txtLogin.getString();
    }

    public void setStatus(String tekst) {
        this.lblStatus.setText(tekst);
    }

    public Uzytkownik getZnaleziony() {
        return znaleziony;
    }

    public void setZnaleziony(Uzytkownik u) {
        this.znaleziony = u;
        this.odswiezWidok();
    }

    private void odswiezWidok() {
        if (this.znaleziony != null)
            this.lblZnaleziony.setText(this.znaleziony.getImie()+" "+this.znaleziony.getNazwisko());
        else
            this.lblZnaleziony.setText("");
    }
}
