package pl.helion.j2mepp.lokalizator;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.*;
import pl.helion.j2mepp.lokalizator.dto.Uzytkownik;
import pl.helion.j2mepp.lokalizator.komunikacja.MenedzerUzytkownikow;
import pl.helion.j2mepp.lokalizator.komunikacja.WebServiceMenedzerUzytkownikow;

public class LokalizatorMIDlet extends MIDlet {
    private LogowanieForm logowanie;
    private RejestracjaForm rejestracja;
    private ZnajomiList znajomi;
    private SzczegolyForm szczegoly;
    private WyszukiwarkaForm wyszukiwarka;

    private Display wyswietlacz = Display.getDisplay(this);

    private MenedzerUzytkownikow menedzerUzyt = new WebServiceMenedzerUzytkownikow();

    public LokalizatorMIDlet() {
        logowanie = new LogowanieForm(new LogowanieFormCommandListener());
        rejestracja = new RejestracjaForm(new RejestracjaFormCommandListener());
        znajomi = new ZnajomiList(new ZnajomiListCommandListener());
        szczegoly = new SzczegolyForm(new SzczegolyFormCommandListener());
        wyszukiwarka = new WyszukiwarkaForm(new WyszukiwarkaFormCommandListener());
        wyswietlacz.setCurrent(logowanie);
    }

    public void startApp() {
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }

    public Alert generujInfo(String tytul, String komunikat) {
        Alert a = new Alert(tytul);
        a.setString(komunikat);
        return a;
    }

    class LogowanieFormCommandListener implements CommandListener {
        public void commandAction(Command c, Displayable d) {
            switch (c.getCommandType()) {
                case Command.OK:
                    String login = logowanie.getLogin();
                    String haslo = logowanie.getHaslo();
                    if (menedzerUzyt.zaloguj(login, haslo)) {
                        menedzerUzyt.init();
                        znajomi.start(menedzerUzyt);
                        wyswietlacz.setCurrent(znajomi);
                    }
                    else
                        wyswietlacz.setCurrent(generujInfo("Błąd!", "Logowanie nie powiodło się!"), logowanie);
                    break;
                case Command.BACK:
                    wyswietlacz.setCurrent(rejestracja);
                    break;
            }
        }
    }

    class RejestracjaFormCommandListener implements CommandListener {
        public void commandAction(Command c, Displayable d) {
            switch (c.getCommandType()) {
                case Command.OK:
                    String login = rejestracja.getLogin();
                    String haslo = rejestracja.getHaslo();
                    String haslo2 = rejestracja.getHaslo2();
                    String imie = rejestracja.getImie();
                    String nazwisko = rejestracja.getNazwisko();
                    if (haslo.equals(haslo2)) {
                        if (menedzerUzyt.zarejestruj(login, haslo, imie, nazwisko))
                            wyswietlacz.setCurrent(generujInfo("Sukces!", "Rejestracja zakończyła się sukcesem!"), logowanie);
                        else
                            wyswietlacz.setCurrent(generujInfo("Błąd!", "Rejestracja nie powiodła się, ponieważ użytkownik o takim loginie już istnieje!"));
                    } else
                        wyswietlacz.setCurrent(generujInfo("Błąd!", "Wprowadzone hasła nie są identyczne!"), rejestracja);
                    break;
                case Command.BACK:
                    wyswietlacz.setCurrent(logowanie);
                    break;
            }
        }
    }
    class ZnajomiListCommandListener implements CommandListener {
        public void commandAction(Command c, Displayable d) {
            switch (c.getCommandType()) {
                case Command.OK:
                    szczegoly.setUzytkownik(znajomi.getWybranyUzytkownik());
                    wyswietlacz.setCurrent(szczegoly);
                    break;
                case Command.BACK:
                    switch (c.getPriority()) {
                        case 0:
                            wyswietlacz.setCurrent(wyszukiwarka);
                            break;
                        case 1:
                            menedzerUzyt.wyloguj();
                            notifyDestroyed();
                            break;
                    }
                    break;
            }
        }
    }
    class SzczegolyFormCommandListener implements CommandListener {
        public void commandAction(Command c, Displayable d) {
            wyswietlacz.setCurrent(znajomi);
        }
    }
    class WyszukiwarkaFormCommandListener implements CommandListener {
        public void commandAction(Command c, Displayable d) {
            switch (c.getCommandType()) {
                case Command.BACK:
                    wyswietlacz.setCurrent(znajomi);
                    break;
                case Command.OK:
                    switch (c.getPriority()) {
                        case 0: // Szukaj
                            String login = wyszukiwarka.getLogin();
                            Uzytkownik u = menedzerUzyt.znajdzUzytkownika(login);
                            if (u != null) {
                                wyszukiwarka.setStatus("Znaleziono użytkownika!");
                                wyszukiwarka.setZnaleziony(u);
                            }
                            break;
                        case 1:
                            u = wyszukiwarka.getZnaleziony();
                            if (u != null) {
                                if (menedzerUzyt.dodajUzytkownika(u.getLogin())) {
                                    wyszukiwarka.setStatus("");
                                    wyszukiwarka.setZnaleziony(null);
                                }
                            }
                            break;
                    }
                    break;
            }
        }
    }

}
