package pl.helion.j2mepp.czytnikrss;

import java.io.*;
import java.util.Vector;
import org.kxml.parser.XmlParser;
import org.kxml.parser.ParseEvent;
import org.kxml.Xml;
public class Parser 
{
	public Parser(CzytnikRSSMIDlet _m)
	{
		m = _m;
	}
	public String pobierz(XmlParser parser) throws IOException
	{
		ParseEvent t;
		String wartosc = "";
		do
		{
			t = parser.read();
			if (t.getType() == Xml.TEXT)
				wartosc += t.getText();
		} while (t.getType()!=Xml.END_TAG);
		return wartosc;
	}
	public Dane pobierzDaneKanalu()
	{
		return daneKanalu;
	}
	private String zwrocProlog() throws Exception
	{
		int b = 0;
		StringBuffer bufor = new StringBuffer();
		while (b!=-1 && ((char)b) != '>')
		{
			b = wej.read();
			bufor.append((char)b);
		}
		if (b==-1) throw new Exception("Nie znaleziono pliku RSS");
		return bufor.toString();
	}
	public XmlParser utworzParser(String s) throws Exception
	{
		XmlParser parser;
		String STALA = "encoding=";
		int j = s.indexOf(STALA);
		if (j>-1)
		{
			s = s.substring(j);
			int l = s.indexOf('"',STALA.length()+1);
			String wynik = s.substring(STALA.length()+1,l);
			if (!wynik.equals(""))
			try
			{
				parser = new XmlParser(new InputStreamReader(wej,wynik));
			}catch (Exception e)
			{
				parser = new XmlParser(new InputStreamReader(wej));
			}
			else
				parser = new XmlParser(new InputStreamReader(wej));
		} else
			parser = new XmlParser(new InputStreamReader(wej));
		return parser;
	}
	public void analizuj(XmlParser parser, ParseEvent t, Dane d) throws IOException
	{
		if (t.getType() == Xml.START_TAG)
		{
			int k = d.sprawdz(t.getName());
			if (k>-1)
			{
				String wartosc = this.pobierz(parser);
				d.ustawElement(wartosc, k);
			}
		}
	}
	public void parsuj(int p_ilosc)
	{
		if (wej==null) return;
		try
		{
			String s = this.zwrocProlog();
			XmlParser parser = this.utworzParser(s);
			ParseEvent t;
			daneKanalu = new Dane(STALE_KANALU_ORG, STALE_KANALU_PL);
			elementy = new Vector();
			do
			{
				t = parser.read();
				this.analizuj(parser, t, daneKanalu);
			} 
			while (t.getType() != Xml.END_DOCUMENT && ((t.getType()==Xml.START_TAG)?!t.getName().equals("item"):true));
			int ilosc = p_ilosc;
			int licznik = 0;
			while ((t.getType() != Xml.END_DOCUMENT)&&((ilosc==0)?true:licznik<ilosc))
			{
				if (t.getType()==Xml.START_TAG && t.getName().equals("item"))
				{
					Dane de = new Dane(STALE_ELEMENTU_ORG,STALE_ELEMENTU_PL);
					do
					{
						this.analizuj(parser, t, de);
						t = parser.read();
					} while ((t.getType()==Xml.END_TAG)?!t.getName().equals("item"):true);
					elementy.addElement(de);
					licznik += 1;
				}
				t = parser.read();
			}
		} 
		catch (Exception e)
		{
			e.printStackTrace();
			m.pokazBlad(e.getMessage());
		}
		for (int i=0;i<elementy.size();i++)
			m.dodajElement((Dane)elementy.elementAt(i));
		m.aktywujListe();
	}
	public void ustawStrumien(InputStream in, int ilosc)
	{
		wej = in;
		this.parsuj(ilosc);
	}
	public Dane pobierzElement(int indeks)
	{
		return (Dane)elementy.elementAt(indeks);
	}
	private CzytnikRSSMIDlet m;
	private InputStream wej;
	private Vector elementy;
	private Dane daneKanalu;
	public static final String[] STALE_KANALU_ORG = new String[]
    {"title", "link", "description","language","pubDate"};
    public static final String[] STALE_KANALU_PL = new String[]
    {"Tytul:","Adres:","Opis:","Jezyk:","Data publikacji:"};
    public static final String[] STALE_ELEMENTU_ORG = new String[]
    {"title", "link", "description","pubDate","author","category"};
    public static final String[] STALE_ELEMENTU_PL = new String[]
    {"Tytul:","Adres:","Opis","Data:","Autor:","Kategoria:"};
}

