package pl.helion.j2mepp.lokalizator.bezpieczenstwo;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import pl.helion.j2mepp.lokalizator.dto.Uzytkownik;

public class MechanizmBezpieczenstwa {

    private Map<String, Wpis> map = new HashMap<String, Wpis>();
    private Random rand = new Random(new Date().getTime());

    public Wpis getWpis(String SID) {
        Wpis e = this.map.get(SID);
        e.setOstatniDostep(new Date());
        return e;
    }
    public String generujSID() {
        StringBuilder sb = new StringBuilder();
        String s = null;
        do {
            for (int i=0;i<15;i++) {
                int n = rand.nextInt(25)+97;
                sb.append((char)n);
            }
            s = sb.toString();
            sb = new StringBuilder();
        } while (this.isWpis(s));
        return s;
    }

    public synchronized void usunWpis(String SID) {
        this.map.remove(SID);
    }
    
    public void putWpis(String SID, Uzytkownik p) {
        Wpis w = new Wpis();
        w.setUzytkownik(p);
        w.setSID(SID);
        w.setOstatniDostep(new Date());
        this.map.put(SID, w);
    }

    public boolean isWpis(String SID) {
        return this.map.get(SID) != null;
    }
}
