/*
 * Decompiled with CFR 0.152.
 */
package com.rychlickikicior.kitijdb;

import com.rychlickikicior.kitijdb.Child;
import com.rychlickikicior.kitijdb.Query;
import com.rychlickikicior.kitijdb.QueryType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Descriptor {
    private Class classObject;
    private List<Query> queries = new ArrayList<Query>();
    private boolean version;
    private List<Child> children = new ArrayList<Child>();

    Descriptor() {
    }

    public Class getClassObject() {
        return this.classObject;
    }

    public void setClassObject(Class classObject) {
        this.classObject = classObject;
    }

    public List<Query> getQueries() {
        return this.queries;
    }

    public void setQueries(List<Query> queries) {
        this.queries = queries;
    }

    public Query findQuery(String name, QueryType type) {
        for (Query q : this.queries) {
            if (!q.getName().equals(name) || type != q.getType()) continue;
            return q;
        }
        return null;
    }

    public void addChild(Class c, String v, Class colType) {
        this.children.add(new Child(c, v, colType));
    }

    public String getChild(Class c) {
        Child child = new Child();
        child.setType(c);
        return this.children.get(this.children.indexOf(child)).getPropertyName();
    }

    public Class getPropertyType(Class classType) {
        Child child = new Child();
        child.setType(classType);
        return this.children.get(this.children.indexOf(child)).getPropertyType();
    }

    public Class getClassByValue(String value) {
        for (Child c : this.children) {
            if (!c.getPropertyName().equals(value)) continue;
            return c.getType();
        }
        return null;
    }

    public Collection<Class> getChildClasses() {
        ArrayList<Class> list = new ArrayList<Class>();
        for (Child c : this.children) {
            list.add(c.getType());
        }
        return list;
    }

    public Collection<String> getChildProperties() {
        ArrayList<String> list = new ArrayList<String>();
        for (Child c : this.children) {
            list.add(c.getPropertyName());
        }
        return list;
    }

    public boolean isVersion() {
        return this.version;
    }

    public void setVersion(boolean version) {
        this.version = version;
    }
}

