/*
 * Decompiled with CFR 0.152.
 */
package pl.helion.j2mepp.czytnikrss;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import org.kxml.parser.ParseEvent;
import org.kxml.parser.XmlParser;
import pl.helion.j2mepp.czytnikrss.CzytnikRSSMIDlet;
import pl.helion.j2mepp.czytnikrss.Dane;

public class Parser {
    private CzytnikRSSMIDlet m;
    private InputStream wej;
    private Vector elementy;
    private Dane daneKanalu;
    public static final String[] STALE_KANALU_ORG = new String[]{"title", "link", "description", "language", "pubDate"};
    public static final String[] STALE_KANALU_PL = new String[]{"Tytul:", "Adres:", "Opis:", "Jezyk:", "Data publikacji:"};
    public static final String[] STALE_ELEMENTU_ORG = new String[]{"title", "link", "description", "pubDate", "author", "category"};
    public static final String[] STALE_ELEMENTU_PL = new String[]{"Tytul:", "Adres:", "Opis", "Data:", "Autor:", "Kategoria:"};

    public Parser(CzytnikRSSMIDlet _m) {
        this.m = _m;
    }

    public String pobierz(XmlParser parser) throws IOException {
        ParseEvent t;
        String wartosc = "";
        do {
            if ((t = parser.read()).getType() != 128) continue;
            wartosc = wartosc + t.getText();
        } while (t.getType() != 16);
        return wartosc;
    }

    public Dane pobierzDaneKanalu() {
        return this.daneKanalu;
    }

    private String zwrocProlog() throws Exception {
        int b = 0;
        StringBuffer bufor = new StringBuffer();
        while (b != -1 && (char)b != '>') {
            b = this.wej.read();
            bufor.append((char)b);
        }
        if (b == -1) {
            throw new Exception("Nie znaleziono pliku RSS");
        }
        return bufor.toString();
    }

    public XmlParser utworzParser(String s) throws Exception {
        XmlParser parser;
        String STALA = "encoding=";
        int j = s.indexOf(STALA);
        if (j > -1) {
            s = s.substring(j);
            int l = s.indexOf(34, STALA.length() + 1);
            String wynik = s.substring(STALA.length() + 1, l);
            if (!wynik.equals("")) {
                try {
                    parser = new XmlParser(new InputStreamReader(this.wej, wynik));
                }
                catch (Exception e) {
                    parser = new XmlParser(new InputStreamReader(this.wej));
                }
            } else {
                parser = new XmlParser(new InputStreamReader(this.wej));
            }
        } else {
            parser = new XmlParser(new InputStreamReader(this.wej));
        }
        return parser;
    }

    public void analizuj(XmlParser parser, ParseEvent t, Dane d) throws IOException {
        int k;
        if (t.getType() == 64 && (k = d.sprawdz(t.getName())) > -1) {
            String wartosc = this.pobierz(parser);
            d.ustawElement(wartosc, k);
        }
    }

    public void parsuj(int p_ilosc) {
        if (this.wej == null) {
            return;
        }
        try {
            ParseEvent t;
            String s = this.zwrocProlog();
            XmlParser parser = this.utworzParser(s);
            this.daneKanalu = new Dane(STALE_KANALU_ORG, STALE_KANALU_PL);
            this.elementy = new Vector();
            do {
                t = parser.read();
                this.analizuj(parser, t, this.daneKanalu);
            } while (t.getType() != 8 && (t.getType() != 64 || !t.getName().equals("item")));
            int ilosc = p_ilosc;
            int licznik = 0;
            while (t.getType() != 8 && (ilosc == 0 || licznik < ilosc)) {
                if (t.getType() == 64 && t.getName().equals("item")) {
                    Dane de = new Dane(STALE_ELEMENTU_ORG, STALE_ELEMENTU_PL);
                    do {
                        this.analizuj(parser, t, de);
                    } while ((t = parser.read()).getType() != 16 || !t.getName().equals("item"));
                    this.elementy.addElement(de);
                    ++licznik;
                }
                t = parser.read();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.m.pokazBlad(e.getMessage());
        }
        for (int i = 0; i < this.elementy.size(); ++i) {
            this.m.dodajElement((Dane)this.elementy.elementAt(i));
        }
        this.m.aktywujListe();
    }

    public void ustawStrumien(InputStream in, int ilosc) {
        this.wej = in;
        this.parsuj(ilosc);
    }

    public Dane pobierzElement(int indeks) {
        return (Dane)this.elementy.elementAt(indeks);
    }
}

