/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.incoming.processor;

import com.sun.xml.ws.security.opt.impl.util.StreamUtil;
import com.sun.xml.wss.impl.c14n.StAXEXC14nCanonicalizerImpl;
import com.sun.xml.wss.logging.impl.opt.signature.LogStringsMessages;
import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceException;
import org.jcp.xml.dsig.internal.DigesterOutputStream;

public class StreamingPayLoadDigester
implements StreamFilter {
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.opt.signature", "com.sun.xml.wss.logging.impl.opt.signature.LogStrings");
    private XMLStreamReader reader = null;
    private Reference ref = null;
    private StAXEXC14nCanonicalizerImpl canonicalizer = null;
    private int index = 0;
    private boolean payLoad = false;
    private boolean digestDone = false;

    public StreamingPayLoadDigester(Reference ref, XMLStreamReader reader, StAXEXC14nCanonicalizerImpl canonicalizer, boolean payLoad) {
        this.ref = ref;
        this.reader = reader;
        this.canonicalizer = canonicalizer;
        this.payLoad = payLoad;
    }

    public boolean accept(XMLStreamReader xMLStreamReader) {
        block17: {
            try {
                if (this.digestDone) break block17;
                StreamUtil.writeCurrentEvent(xMLStreamReader, this.canonicalizer);
                if (this.reader.getEventType() == 1) {
                    ++this.index;
                    break block17;
                }
                if (this.reader.getEventType() != 2) break block17;
                --this.index;
                if (this.index != 0) break block17;
                byte[] originalDigest = this.ref.getDigestValue();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, LogStringsMessages.WSS_1763_ACTUAL_DEGEST_VALUE(new String(originalDigest)));
                }
                this.canonicalizer.writeEndDocument();
                this.digestDone = true;
                if (this.canonicalizer.getOutputStream() instanceof DigesterOutputStream) {
                    byte[] calculatedDigest = ((DigesterOutputStream)this.canonicalizer.getOutputStream()).getDigestValue();
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, LogStringsMessages.WSS_1762_CALCULATED_DIGEST_VALUE(new String(calculatedDigest)));
                    }
                    if (!Arrays.equals(originalDigest, calculatedDigest)) {
                        XMLSignatureException xe = new XMLSignatureException(LogStringsMessages.WSS_1717_ERROR_PAYLOAD_VERIFICATION());
                        logger.log(Level.SEVERE, LogStringsMessages.WSS_1717_ERROR_PAYLOAD_VERIFICATION(), xe);
                        throw new WebServiceException((Throwable)xe);
                    }
                    if (logger.isLoggable(Level.FINEST)) {
                        if (!this.payLoad) {
                            logger.log(Level.FINEST, "Digest verification of Body was successful");
                        } else {
                            logger.log(Level.FINEST, "Digest verification of PayLoad was successful");
                        }
                    }
                    break block17;
                }
                if (!(this.canonicalizer.getOutputStream() instanceof ByteArrayOutputStream)) break block17;
                byte[] canonicalizedData = ((ByteArrayOutputStream)this.canonicalizer.getOutputStream()).toByteArray();
                byte[] calculatedDigest = null;
                MessageDigest md = null;
                try {
                    md = MessageDigest.getInstance("SHA-1");
                }
                catch (NoSuchAlgorithmException nsae) {
                    logger.log(Level.SEVERE, LogStringsMessages.WSS_1705_INVALID_DIGEST_ALGORITHM("SHA-1"), nsae);
                    throw new WebServiceException((Throwable)nsae);
                }
                calculatedDigest = md.digest(canonicalizedData);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, LogStringsMessages.WSS_1762_CALCULATED_DIGEST_VALUE(new String(calculatedDigest)));
                    logger.log(Level.FINEST, LogStringsMessages.WSS_1764_CANONICALIZED_PAYLOAD_VALUE(new String(canonicalizedData)));
                }
                if (!Arrays.equals(originalDigest, calculatedDigest)) {
                    XMLSignatureException xe = new XMLSignatureException(LogStringsMessages.WSS_1717_ERROR_PAYLOAD_VERIFICATION());
                    logger.log(Level.SEVERE, LogStringsMessages.WSS_1717_ERROR_PAYLOAD_VERIFICATION(), xe);
                    throw new WebServiceException((Throwable)xe);
                }
                if (logger.isLoggable(Level.FINEST)) {
                    if (!this.payLoad) {
                        logger.log(Level.FINEST, "Digest verification of Body was successful");
                    } else {
                        logger.log(Level.FINEST, "Digest verification of PayLoad was successful");
                    }
                }
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1717_ERROR_PAYLOAD_VERIFICATION(), ex);
                throw new WebServiceException((Throwable)ex);
            }
        }
        return true;
    }
}

