/*
 * Decompiled with CFR 0.152.
 */
package pl.helion.j2mepp.zdalnakamera.komunikacja;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import pl.helion.j2mepp.zdalnakamera.komunikacja.MenedzerObrazow;

public class HttpMenedzerObrazow
implements MenedzerObrazow {
    private String sid;
    private String url;

    public boolean init(String url) {
        this.url = url;
        return true;
    }

    public String generujSID() {
        try {
            String sid;
            HttpConnection polaczenie = this.utworzPolaczenieHttp("generujSID");
            DataInputStream dis = polaczenie.openDataInputStream();
            byte[] bufor = new byte[1024];
            int rozmiar = dis.read(bufor, 0, 1024);
            this.sid = sid = new String(bufor, 0, rozmiar);
            System.out.println(sid);
            dis.close();
            polaczenie.close();
            return sid;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public boolean wyslijZdjecie(byte[] obraz) {
        try {
            HttpConnection polaczenie = this.utworzPolaczenieHttp("wyslijZdjecie");
            polaczenie.setRequestProperty("Content-Type", "multipart/form-data; boundary=----J2METEST");
            OutputStream os = polaczenie.openOutputStream();
            byte[] dane = this.wygenerujTresc(obraz);
            os.write(dane);
            os.close();
            polaczenie.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
        return true;
    }

    public InputStream getZdjecie() {
        try {
            HttpConnection hc = this.utworzPolaczenieHttp("pobierzZdjecie");
            InputStream is = hc.openInputStream();
            return is;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public void wyloguj() {
        try {
            HttpConnection hc = this.utworzPolaczenieHttp("wyloguj");
            InputStream is = hc.openInputStream();
            is.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void setSID(String sid) {
        this.sid = sid;
    }

    private HttpConnection utworzPolaczenieHttp(String akcja) throws IOException {
        String pelnyURL = this.url + "?SID=" + this.sid + "&akcja=" + akcja;
        HttpConnection polaczenie = (HttpConnection)Connector.open((String)pelnyURL);
        polaczenie.setRequestMethod("POST");
        return polaczenie;
    }

    private byte[] wygenerujTresc(byte[] obraz) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write("------J2METEST\r\n".getBytes());
        baos.write("Content-Disposition: form-data; name=\"plik\"; filename=\"plik.jpg\"\r\nContent-Type: image/jpeg\r\n\r\n".getBytes());
        baos.write(obraz);
        baos.write("\r\n------J2METEST--\r\n".getBytes());
        return baos.toByteArray();
    }
}

