/*
 * Decompiled with CFR 0.152.
 */
package pl.helion.j2mepp.odtwarzacz;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.file.FileConnection;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import pl.helion.j2mepp.odtwarzacz.OdtwarzaczMIDlet;

public class CzytnikDanych {
    private String typ;
    private InputStream strumien;
    private RecordStore zbior;
    private OdtwarzaczMIDlet m;

    public CzytnikDanych(OdtwarzaczMIDlet p_m) {
        this.m = p_m;
        try {
            this.zbior = RecordStore.openRecordStore((String)"media", (boolean)true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void zapisz(String nazwa, byte[] bufor) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(baos);
            out.writeUTF(nazwa);
            out.write(bufor);
            byte[] dane = baos.toByteArray();
            this.zbior.addRecord(dane, 0, dane.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void koniec() {
        try {
            this.zbior.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String[] pobierzID() {
        String[] wyniki = new String[]{};
        try {
            wyniki = new String[this.zbior.getNumRecords()];
            RecordEnumeration prz = this.zbior.enumerateRecords(null, null, false);
            int i = 0;
            while (prz.hasNextElement()) {
                wyniki[i] = prz.nextRecordId() + "";
                ++i;
            }
            return wyniki;
        }
        catch (Exception e) {
            e.printStackTrace();
            return wyniki;
        }
    }

    public String rozszerzenieWTyp(String uri) {
        String roz = uri.substring(uri.lastIndexOf(46) + 1, uri.length());
        String typ = "";
        if (roz.equals("wav")) {
            typ = "audio/x-wav";
        }
        if (roz.equals("mpg")) {
            typ = "video/mpeg";
        }
        if (roz.equals("mid")) {
            typ = "audio/midi";
        }
        if (roz.equals("jpg")) {
            typ = "image/jpeg";
        }
        if (roz.equals("png")) {
            typ = "image/png";
        }
        if (roz.equals("gif")) {
            typ = "image/gif";
        }
        return typ;
    }

    public Player analizuj(String uri) {
        Player p = null;
        try {
            String v;
            String protokol = uri.substring(0, 4);
            if (protokol.equals("http")) {
                HttpConnection pol = (HttpConnection)Connector.open((String)uri);
                this.typ = this.rozszerzenieWTyp(uri);
                if (this.typ.startsWith("image")) {
                    this.strumien = pol.openInputStream();
                } else {
                    p = Manager.createPlayer((String)uri);
                }
            }
            if (protokol.equals("file") && (v = System.getProperty("microedition.io.file.FileConnection.version")) != null) {
                this.typ = this.rozszerzenieWTyp(uri);
                if (this.typ.startsWith("image")) {
                    FileConnection ic = (FileConnection)Connector.open((String)uri, (int)1);
                    this.strumien = ic.openInputStream();
                } else {
                    p = Manager.createPlayer((String)uri);
                }
            }
            if (protokol.equals(" rms")) {
                String ID = uri.substring(uri.lastIndexOf(47) + 1, uri.length());
                byte[] bufor = this.zbior.getRecord(Integer.parseInt(ID));
                DataInputStream in = new DataInputStream(new ByteArrayInputStream(bufor));
                this.typ = in.readUTF();
                int dlugosc = bufor.length - this.typ.length();
                byte[] dane = new byte[dlugosc];
                in.read(dane);
                this.strumien = new ByteArrayInputStream(dane);
                if (!this.typ.startsWith("image")) {
                    p = Manager.createPlayer((InputStream)this.strumien, (String)this.typ);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.m.destroyApp(true);
            this.m.notifyDestroyed();
        }
        return p;
    }

    public InputStream getStrumien() {
        return this.strumien;
    }

    public String getTyp() {
        return this.typ;
    }
}

