// Example 10-5: Customer object with locking interface

package com.oreilly.patterns.chapter10;

public class Customer implements Lockable {

    private String lockingUser = null;
    private Object lockSynchronizer = new Object();

    public void lock(String username) throws LockingException {
        if (username == null) throw new LockingException("Nie podano nazwy uyt-kownika.");
        synchronized(lockSynchronizer) {
            if(lockingUser == null)
                lockingUser = username;
            else if ((lockingUser != null) && (!lockingUser.equals(username)))
                throw new LockingException("Zasb jest ju zablokowany");
        }
    }

    public void unlock(String username) throws LockingException {
        if((lockingUser != null) && (lockingUser.equals(username)))
            lockingUser = null;
        else if (lockingUser != null)
            throw new LockingException("Nie jeste wacicielem blokady.");
    }

    public boolean isLocked() {
        return (lockingUser != null);
    }

    // tutaj naley umieci metody get i set klasy Customer
}
