
package pool;

import java.util.*;

/**
 * Implementacja oglnej puli zasobw uywajcej fabryk.
 */
public class ResourcePool {
    /** fabryka */
    private ResourceFactory factory;
    
    /** liczniki */
    private int maxObjects;
    private int curObjects;
    private boolean quit;
    
    /** wynajte zasoby */
    private Set outResources;
    
    /** zasoby do wynajcia */
    private List inResources;
    
    /**
     * Tworzy now pul zasobw, ktra generuje obiekty za pomoc
     * przekazanej jej fabryki, i przechowuje co najwyej maxObjects obiektw.
     */
    public ResourcePool(ResourceFactory factory, int maxObjects) {
        this.factory = factory;
        this.maxObjects = maxObjects;
        
        curObjects = 0;
        
        outResources = new HashSet(maxObjects);
        inResources = new LinkedList();
    }
    
    /**
     * Pobiera zasb z puli
     */
    public synchronized Object getResource() throws Exception {
        while(!quit) {
        
            // najpierw prbuje zwrci zasb z puli
            if (!inResources.isEmpty()) {
                Object o = inResources.remove(0);
                
                // jeli nie jest poprawny, to tworzy kolejny
                if(!factory.validateResource(o))
                    o = factory.createResource();
                
                outResources.add(o);
                return o;
            }
            
            // tworzy nowy zasb jeli
            // limit nie zosta osignity
            if(curObjects < maxObjects) {
                Object o = factory.createResource();
                outResources.add(o);
                curObjects++;
                
                return o;
            }
            
            // jeli brak jest dostpnych zasobw w puli, 
            // to oczekuje a jaki zostanie zwrcony
            try { wait(); } catch(Exception ex) {}
        }
    
        // pula zostaa usunita
        return null;
    }
    
    /**
     * Zwraca zasb do puli.
     */
    public synchronized void returnResource(Object o) {
        
        // Co jest nie tak.  Poddaje si.
        if(!outResources.remove(o))
            return;
        
        inResources.add(o);
        notify();
    }
    
    /**
     * Usunicie puli
     */
    public synchronized void destroy() {
        quit = true;
        notifyAll();
    }
}

