package vhexample.view;

import javax.servlet.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;

/**
 * Klasa reprezentujca znacznik RSSItems.  Przeglda wszystkie elementy
 * kanau RSS udostepniajc nazw i cze kadego elementu
 * jako zmienne skryptu.
 */
public class RSSItemsTag extends BodyTagSupport implements IterationTag {
    /** nazwy zmiennych skryptu */
    private static final String NAME_ATTR = "itemName";
    private static final String LINK_ATTR = "itemLink";
    
    /** indeks biecego elementu kanau */
    private int counter;
    
    /** parser RSS */
    private RSSInfo rssInfo;
    
    /**
     * Konstruktor
     */
    public RSSItemsTag() {
        super();   
        counter = 0;
    }
    
    /**
     * Pobiera parser RSS od nadrzdnego znacznika i nadaje pocztkowe
     * wartoci zmiennym skryptu.
     */
    public int doStartTag() throws JspException {
        if (rssInfo == null) {
            RSSChannelTag rct = 
                (RSSChannelTag)findAncestorWithClass(this, RSSChannelTag.class);
           rssInfo = rct.getRSSInfo();
        }
        
        pageContext.setAttribute(NAME_ATTR, rssInfo.getTitleAt(counter));
        pageContext.setAttribute(LINK_ATTR, rssInfo.getLinkAt(counter));
        return Tag.EVAL_BODY_INCLUDE;
    }
 
    /**
     * Po kadym przebiegu zwiksza licznik.  Jeli istniej jeszcze jakie 
     * elementy, to inicjuje zmienne skryptu.
     */
    public int doAfterBody() throws JspException {
        if (++counter >= rssInfo.getItemCount()) {
            return IterationTag.SKIP_BODY;
        } else {     
            pageContext.setAttribute(NAME_ATTR, rssInfo.getTitleAt(counter));
            pageContext.setAttribute(LINK_ATTR, rssInfo.getLinkAt(counter));
            return IterationTag.EVAL_BODY_AGAIN;
        }
    }
}
