package vhexample.view;

import javax.servlet.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;

/**
 * Wasna etykieta dla kanau RSS.  Posiada dwie zmienne skryptu
 * okrelajce nazw kanau i jego cze.  Uywana rwnie przez 
 * zagniedone etykiety w celu uzyskania informacji o kadym elemencie kanau.
 */
public class RSSChannelTag extends BodyTagSupport {
    /** nazwy zmiennych skryptu */
    private static final String NAME_ATTR = "channelName";
    private static final String LINK_ATTR = "channelLink";
    
    /** adres url strony RSS */
    private String url;
    
    /** parser RSS */
    private RSSInfo rssInfo;
    
    /**
     * Konstruktor 
     */
    public RSSChannelTag() {
        rssInfo = new RSSInfo();
    }
    
    /**
     * Wywoywana z atrybutem URL etykiety jako parametrem
     */
    public void setURL(String url) {
        this.url = url;
    }
    
    /**
     * Wywoywana przez zagniedone etykiety dla pobrania parsera
     */
    protected RSSInfo getRSSInfo() {
        return rssInfo;
    }
    
    /**
     * Parsuje RSS i nadaje wartoci zmiennym skryptu
     */
    public int doStartTag() throws JspException {
        try {
            // parsuje rss
            rssInfo.parse(url);
            
            // eksportuje zmienne skryptu
            pageContext.setAttribute(NAME_ATTR, rssInfo.getChannelTitle());
            pageContext.setAttribute(LINK_ATTR, rssInfo.getChannelLink());
        } catch (Exception ex) {
            throw new JspException("Prolem z parsowaniem " + url, ex);
        }
        
        return Tag.EVAL_BODY_INCLUDE;
    }
}
