package s2wexample.controller.actions;

import s2wexample.controller.*;
import s2wexample.model.*;
import javax.servlet.http.*;
import javax.servlet.*;

/**
 * Akcja logowania uytkownika
 */
public class LoginAction implements Action {
    /** Nazwa komponentu UserBean dla sesji */
    public static final String USERBEAN_ATTR = "userbean";
    
    /** parametry wsplne ze stron JSP */
    private static final String NAME_PARAM = "username";
    private static final String PASSWORD_PARAM = "password";
    
    /**
     * Wykonuje akcj.  Prbuje zalogowa uytkownika w oparciu
     * o nazw i haso przekazane przez danie
     */
    public boolean performAction(HttpServletRequest req, 
                                 ServletContext context)
    {
        // odczytuje nazw uytkownika i haso z dania
        String username = req.getParameter(NAME_PARAM);
        String password = req.getParameter(PASSWORD_PARAM);
        
        // pobiera komponent UserBean dla sesji
        HttpSession session = req.getSession();
        UserBean ub = (UserBean) session.getAttribute(USERBEAN_ATTR);
        
        // jeli komponent nie istnieje, to tworzy go
        if (ub == null) {
            ub = UserBeanFactory.newInstance();
            session.setAttribute(USERBEAN_ATTR, ub); 
        }
        
        // okrela parametry komponentu
        ub.setUsername(username);
        ub.setPassword(password);
        
        // prbuje zalogowa uytkownika
        return ub.doLogin();
    } 
}
