package cvexample.view;

import javax.servlet.jsp.tagext.*;
import javax.servlet.jsp.*;
import javax.servlet.*;
import java.io.*;

import cvexample.controller.*;

/**
 * Wasna etykieta zagniedona wewntrz etykiety kontenera i zawierajca
 * element kompozytu.
 */
public class ContainerIncludeTag extends TagSupport {
    /** nazwa elementu kompozytu */
    private String name;
      
    /**
     * Pobiera widok z biecego kontenera i tworzy odwzorowanie
     * pomidzy etykiet i stron, ktr naley wywietli
     */
    public int doEndTag() throws JspException {
        // znajduje etykiet kontenera i pobiera z niego widok
        ContainerTag ct =
            (ContainerTag) findAncestorWithClass(this, ContainerTag.class);     
        View v = ct.getView();
        
        // pobiera adres url widoku
        String viewURL = v.getUrl(ct.getName(), name);
        if (viewURL != null) {
            try {    
                // docza
                pageContext.include(viewURL);
            } catch( Exception ex ) {
                throw new JspException("Nie mona doczy " + viewURL, ex);
            }
        }
        return EVAL_PAGE;
    }
     
    /**
     * Uywana przez kontener do okrelenia nazwy elementu kompozytu
     */
    public void setName(String value) {
        name = value;
    }
}
