package mvcexample.controller;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.IOException;

import mvcexample.model.*;

/**
 * Prosta implementacja kontrolera wykorzystujca serwlet 
 * oraz model MailingBean.
 */
public class ListController extends HttpServlet {
    // Parametry wsplne z JSP.  Wartoci musz by takie same 
    // jak nazwy waciwoci w plikach JSP.
    public static final String FIRST_PARAM = "first";
    public static final String LAST_PARAM = "last";
    public static final String EMAIL_PARAM = "email";
    public static final String MAILINGBEAN_ATTR = "mailingbean";
    
    /**
     * Obsuga dania HTTP GET.
     */    
    protected void doGet(HttpServletRequest request, 
                         HttpServletResponse response)
        throws ServletException, IOException
    {
        // odczytuje parametry dania
        String first = request.getParameter(FIRST_PARAM);
        String last = request.getParameter(LAST_PARAM);
        String email = request.getParameter(EMAIL_PARAM);
        
        // pobiera komponent dla tej listy
        MailingBean mb = MailingBeanFactory.newInstance();
       
        // okrela parametry komponentu
        mb.setFirst(first);
        mb.setLast(last);
        mb.setEmail(email);
       
        // przechowuje kopi komponentu w kontekcie dania
        request.setAttribute(MAILINGBEAN_ATTR, mb);
        
        // wykonuje metod biznesow
        boolean result = mb.doSubscribe();
      
        // wybiera stron na podstawie wyniku
        String nextPage = "/success.jsp";
        if (!result) nextPage = "/failure.jsp";
       
        // przekazuje sterowanie do wybranego widoku
        RequestDispatcher dispatcher = 
            getServletContext().getRequestDispatcher(nextPage);
        dispatcher.forward(request, response);	
    }
}

