
package antipatterns.ejbs;

import javax.ejb.*;
import java.util.*;
import javax.naming.*;

/**
 * Created Jan 1, 2003 10:34:21 PM
 * Code generated by the Forte For Java EJB Builder
 * @author jon
 */


public class PersonFacadeBean implements SessionBean {
    private SessionContext context;
    private LocalEJBPersonHome personHome;
    
    public void setSessionContext(SessionContext aContext) {
        context=aContext;
    }
    
    public void ejbActivate() {}
    public void ejbPassivate() {}
    
    public void ejbRemove() {}  
    public void ejbCreate() {
        try {
            InitialContext ic = new InitialContext();
            personHome = (LocalEJBPersonHome)ic.lookup("java:comp/env/ejb/local/Person");
        } catch(Exception ex) {
            throw new EJBException("Error looking up PersonHome: " + ex, ex);
        }
    }
    
    public PeopleDTO findByName(String firstName, String lastName)
    throws FinderException {
        Collection c = null;
        if (firstName != null && lastName != null) {
            c = personHome.findByName(firstName, lastName);
        } else if (firstName != null) {
            c = personHome.findByFirstName(firstName);
        } else if (lastName != null) {
            c = personHome.findByLastName(lastName);
        } else {
            c = personHome.findAll();
        }
        
        return getDTOFromCollection(c);
    }
    
    private PeopleDTO getDTOFromCollection(Collection people) {
        PeopleDTO dto = new PeopleDTO();
        
        for (Iterator i = people.iterator(); i.hasNext();) {
            LocalEJBPerson ejbPerson = (LocalEJBPerson)i.next();
        
            dto.addPerson(new Person(ejbPerson.getFirstName(), 
                                     ejbPerson.getLastName(), 
                                     ejbPerson.getPhoneNumber()));
        }
    
        return dto;
    }
}
