package cvexample.controller;

import java.util.*;

/**
 * Wewntrzna reprezentacja widokw opisanych w pliku views.xml
 */
public class View {  
    /** odzworowanie konetenerw widoku */
    private HashMap containers;
    
    /** szblon widoku */
    private String template;
    
    /**
     * Wewntrzna reprezentacja kontenera nalecego do widoku
     */
    class Container {
        /** odwzorowanie zacznikw kontenera */
        private HashMap includes;
        
        Container() {
            includes = new HashMap();
        }
        
        /**
         * Dodaje zacznik do kontenera
         */
        void addInclude(String name, String url) {
            includes.put(name, url);
        }
    
        /**
         * Zwraca adres URL zwizany z danym zacznikiem.
         */
        String getUrl(String name) {
            return (String) includes.get(name);
        }
    }
    
    /**
     * Tworzy nowy widok o okrelonym szablonie.
     */
    public View(String template) {
        containers = new HashMap();
        this.template = template;
    }
    
    /**
     * Umieszcza zacznik w widoku.
     */
    public void addInclude(String container, String name, String url) {
        // odnajduje kontener
        Container c = (Container) containers.get(container);
        
        // Jeli kontener nie istniej, to tworzy go
        if (c == null) {
            c = new Container();
            containers.put(container, c);
        }
        
        // umieszcza zacznik w kontenerze
        c.addInclude(name, url);
    }
    
    /**
     * Zwraca adres URL zwizany z widokiem o okrelonej nazwie
     */
    public String getUrl(String container, String name) {
        // odnajduje kontener
        Container c = (Container) containers.get(container);
        if (c == null) {
            return null;
        }
        
        // zwraca adres URL
        return c.getUrl(name);
    }
    
    /**
     * Sprawdza czy dany widok posiada kontener o podanej nazwie
     */
    public boolean hasContainer(String container) {
        return containers.containsKey(container);
    }
    
    /**
     * Zwraca szablon dla danego widoku
     */
    public String getTemplate() {
        return template;
    }
}