package fcexample.model;

/**
 * Implementacja interfejsu UserBean uywajca zmiennych lokalnych.
 * Prawdziwa implementacja powinna uywa odpowiedniego mechanizmu
 * logowania uytkownika.
 */
public class UserBeanImpl implements UserBean {
    /** nazwa uytkownika */
    private String username;
    
    /** haso */
    private String password;
    
    /** uytkownik zalogowany? */
    private boolean loggedIn;
    
    /**
     * zwraca nazw uytkownika
     */
    public String getUsername() {
        return this.username;
    }
    
    /**
     * okrela nazw uytkownika
     */
    public void setUsername(String username) {
        this.username = username;
    }
    
    /**
     * zwraca haso
     */
    public String getPassword() {
        return this.password;
    }
    
    /**
     * okrela haso
     */
    public void setPassword(String password) {
        this.password = password;
    }
    
    /**
     * Metoda biznesowa logowania.  Sprawdza, czy okrelone zostao haso
     * dusze ni trzy znaki.  Prawdziwa wersja tej metody powinna korzysta
     * z odpowiedniego mechanizmu uwiarygadniania uytkownika.
     */
    public boolean doLogin() {
        if (password == null || password.length() < 3) {
            setLoggedIn(false);
        } else {
            setLoggedIn(true);
        }
        
        return isLoggedIn();
    }
    
    /**
     * Okrela czy uytkownik jest zalogowany
     */
    private void setLoggedIn(boolean loggedIn) {
        this.loggedIn = loggedIn;
    }
        
    /**
     * Sprawdza czy uytkownik jest zalogowany
     */
    public boolean isLoggedIn() {
        return loggedIn;
    }
}
