package decoratorexample.controller;

import java.io.*;
import java.net.*;
import java.util.*;
import java.text.*;
import javax.servlet.*;
import javax.servlet.http.*;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

/**
 * Prosty filtr prezentujcy informacj o odbieranych daniach.
 */
public class RequestInfoFilter implements Filter {
    // opis konfiguracji filtra
    private FilterConfig filterConfig = null;
    
    /**
     * Konstruktor
     */
    public RequestInfoFilter() {
    }
    
    /**
     * Wywoywana podczas inicjacji filtra
     */
    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }
 
    /**
     * Wykonuje waciwe filtrowanie.  Zapisuje parametry i atrybuty da
     * w dzienniku ServletContext
     */
    public void doFilter(ServletRequest request, 
                         ServletResponse response,
                         FilterChain chain)
        throws IOException, ServletException 
    {
        ServletContext sc = filterConfig.getServletContext();
        
        // wstpne przetwaanie dania
        HttpServletRequest hrs = (HttpServletRequest)request;
        sc.log("Atrybuty dania:");
        sc.log("Method: " + hrs.getMethod());
        sc.log("QueryString: " + hrs.getQueryString());
        sc.log("Context: " + hrs.getContextPath());
        sc.log("RequestURL: " + hrs.getRequestURL());
        sc.log("RequestURI: " + hrs.getRequestURI());
        sc.log("PathInfo: " + hrs.getPathInfo());
        sc.log("ServletPath: " + hrs.getServletPath());
     
        // wyliczenie parametrw
        sc.log("Parametry:");    
        for (Enumeration e = request.getParameterNames(); e.hasMoreElements(); ) {
             String name = (String) e.nextElement();
             String vals[] = request.getParameterValues(name);
             
             StringBuffer out = new StringBuffer();
             out.append(name + "=");
             
             // kady parametr moe posiada wiele wartoci
             for(int i = 0; i < vals.length; i++) {
                 out.append(vals[i]);
             }
             
             // usuwa przecinki
             sc.log(out.substring(0, out.length() - 1));
        }
        
        // wywouje kolejny filtr w acuchu
        chain.doFilter(request, response);
    }
     
    /**
     * Wywoywana podczas deaktywacji filtra
     */
    public void destroy() {
    }
}
