// Listing 9.6 - klasa ServiceLocator

package com.oreilly.patterns.chapter9;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.ejb.EJBHome;
import javax.ejb.HomeHandle;
import javax.rmi.PortableRemoteObject;
import java.util.HashMap;
import java.rmi.RemoteException;

public class ServiceLocator {

 private static ServiceLocator instance;
 private HashMap cache;
 private Context context;
 
 // zwraca singleton lokalizatora usug       
 public static ServiceLocator getInstance()
 throws ServiceLocatorException {
  if (instance == null)
   instance = new ServiceLocator();
  
  return instance;
 }
    
 // tworzy now instancj klasy ServiceLocator
 private ServiceLocator() throws ServiceLocatorException {
  cache = new HashMap();
  
  // inicjuje wspdzielony obiekt kontekstu
  try {
   context = new InitialContext();
  } catch(NamingException ne) {
   throw new ServiceLocatorException("Nie mona utworzy " + 
    "obiektu InitialContext", ne);
  }
 }
 
 // pobiera komponent EJB z bufora lub usugi katalogowej
 public EJBHome getRemoteEJB(String name, Class type)
 throws ServiceLocatorException {
  // sprawdza czy obiekt nie znajduje si w buforze
  if (cache.containsKey(name)) {
   // umieszcza obiekty HomeHandle w buforze, poniewa 
   // s one utrzymywane przez kontener
   HomeHandle hh = (HomeHandle)cache.get(name);
            
   try {
    return hh.getEJBHome();
   } catch(RemoteException re) {
    // problem  prbuje ponownie
    // wyszuka poniej
   }
  }
  
  // Dostp do wspdzielonego kontekstu oraz modyfikacje
  // mapy HashMap musz korzysta ze synchronizacji.  
  // Prawdopodobnie wikszo przypadkw zostaa ju obsuona powyej  synchronized(this) {
   try {
    Object rRef = context.lookup(name);
    EJBHome eh = 
     (EJBHome)PortableRemoteObject.narrow(rRef, type);
    
    cache.put(name, eh.getHomeHandle());
    return eh;
   } catch(Exception ex) {
    throw new ServiceLocatorException("Nie mona odnale komponentu EJB",
     ex);
   }
  }
 }
}
