package cvexample.view;

import javax.servlet.jsp.tagext.*;
import javax.servlet.jsp.*;
import javax.servlet.*;
import java.io.*;

import cvexample.controller.*;

/**
 * Wasna etykieta umoliwiajca umieszczanie nazw kontenerw w JSP.  
 * Zawiera zagniedone etykiety ContainerIncludeTags.
 */
public class ContainerTag extends TagSupport {
    /** nazwa danego widoku */
    private static final String VIEW_ATTR = "view";
    
    /** nazwa kontenera */
    private String name;   
    
    /** widok zwizany z tym kontenerem */
    private View view;
      
    /**
     * Sprawdza, czy istnieje dany widok.  Jeli tak, 
     * to kontynuuje dla zagniedonych etykiet.  
     * W przeciwnym razie przerywa dziaanie.
     */
    public int doStartTag() throws JspException, JspException { 
        // znajduje dany widok
        view = (View) pageContext.getRequest().getAttribute(VIEW_ATTR);
        
        // sprawdza, czy posiada on dany kontener
        if (!view.hasContainer(name))
            return SKIP_BODY;
        
        return EVAL_BODY_INCLUDE;
    }

    /**
     * Pobiera widok zwizany z kontenerem.  Uywana 
     * przez ContainerIncludeTag
     */
    public View getView() {
        return view;
    }
       
    /**
     * Wywoywana przez sam etykiet w celu okrelenia nazwy kontenera
     */
    public void setName(String value) {
        name = value;
    }
    
    /**
     * Zwraca nazw kontenera.
     */
    public String getName() {
        return name;
    }
}
