
#import "UITableViewCell+NibLoadingAdditions.h"

@implementation UITableViewCell (NibLoadingAdditions)

+ (UITableViewCell *) cellFromNib:(NSString *) nib {
	NSArray *nibTopLevels = [[NSBundle mainBundle] loadNibNamed:nib owner:self options:nil];
	id firstTopLevelObject = [nibTopLevels objectAtIndex:0];
	if ( [ firstTopLevelObject isKindOfClass:[UITableViewCell class]] )
		return firstTopLevelObject;	
	return [nibTopLevels objectAtIndex:1];
}

@end
