/*
 Erica Sadun, http://ericasadun.com
 iPhone Developer's Cookbook, 5.x Edition
 BSD License, Use at your own risk
 */

#import "ObjectCache.h"

@implementation ObjectCache
@synthesize myCache, allocationSize;

+ (ObjectCache *) cache
{
	return [[ObjectCache alloc] init];
}

// Symulacja wczytania obiektów poprzez utworzenie obiektu typu NSData o podanej wielkości.
- (id) loadObjectNamed: (NSString *) someKey
{
    if (!allocationSize)
        allocationSize = 1024 * 1024;

    char *foo = malloc(allocationSize);
    NSData *data = [NSData dataWithBytes:foo length:allocationSize];
    free(foo);
    return data;
}

// Kiedy obiekt nie zostanie znaleziony, oznacza to, że został wczytany.
- (id) retrieveObjectNamed: (NSString *) someKey
{
    if (!myCache) 
        self.myCache = [NSMutableDictionary dictionary];
	id object = [myCache objectForKey:someKey];
	if (!object) 
	{
		if ((object = [self loadObjectNamed:someKey]))
            [myCache setObject:object forKey:someKey];
	}
	return object;
}

// Opróżnienie bufora po otrzymaniu informacji, że w urządzeniu pozostała niewielka ilość wolnej pamięci.
- (void) respondToMemoryWarning
{
	[myCache removeAllObjects];
}
@end
