/*
 Erica Sadun, http://ericasadun.com
 iPhone Developer's Cookbook, 5.x Edition
 BSD License, Use at your own risk
 */

#import "ReflectingView.h"

@implementation ReflectingView
@synthesize usesGradientOverlay;

// Zawsze używaj replikatora jako warstwy bazowej.
+ (Class) layerClass
{
    return [CAReplicatorLayer class];
}

// Usunięcie wszystkich istniejących gradientów w widoku nadrzędnym.
- (void) dealloc
{
    [gradient removeFromSuperlayer];
}

- (void) setupGradient
{
    // Dodanie nowej warstwy gradient do widoku nadrzędnego.
    UIView *parent = self.superview;
    if (!gradient)
    {
        gradient = [CAGradientLayer layer];
        CGColorRef c1 = [[UIColor blackColor] colorWithAlphaComponent:0.5f].CGColor;
        CGColorRef c2 = [[UIColor blackColor] colorWithAlphaComponent:0.9f].CGColor;
        [gradient setColors:[NSArray arrayWithObjects:
                             (__bridge id)c1, (__bridge id)c2, nil]];
        [parent.layer addSublayer:gradient];
    }
    
    // Umieszczenie warstwy gradient tuż pod widokiem przy użyciu geometrii odbicia.
    float desiredGap = 10.0f;
    CGFloat shrinkFactor = 0.25f;
    CGFloat height = self.bounds.size.height;
    CGFloat width = self.bounds.size.width;
    CGFloat y = self.frame.origin.y;
    
    [gradient setAnchorPoint:CGPointMake(0.0f,0.0f)];
    [gradient setFrame:CGRectMake(0.0f, y + height + desiredGap, width, height * shrinkFactor)];
    [gradient removeAllAnimations];
}

- (void) setupReflection
{
    CGFloat height = self.bounds.size.height;
    CGFloat shrinkFactor = 0.25f;
    
    CATransform3D t = CATransform3DMakeScale(1.0, -shrinkFactor, 1.0);
    
    // Skalowanie powoduje wyśrodkowanie cienia w widoku.
    float offsetFromBottom = height * ((1.0f - shrinkFactor) / 2.0f);
    float inverse = 1.0 / shrinkFactor;
    float desiredGap = 10.0f;
    t = CATransform3DTranslate(t, 0.0, -offsetFromBottom * inverse - height - inverse * desiredGap, 0.0f);
    
    CAReplicatorLayer *replicatorLayer = (CAReplicatorLayer*)self.layer;
    replicatorLayer.instanceTransform = t;
    replicatorLayer.instanceCount = 2;
    
    // Użycie gradientu musi być wyraźnie zdefiniowane.
    if (usesGradientOverlay)
        [self setupGradient];
    else
    {
        // Przyciemnienie odbicia, kiedy gradient nie jest używany.
        replicatorLayer.instanceRedOffset = -0.75;
        replicatorLayer.instanceGreenOffset = -0.75;
        replicatorLayer.instanceBlueOffset = -0.75;
    }
}
@end