#!/usr/local/bin/python
# coding: utf-8
import math
import random
import numpy as np
import matplotlib.pyplot as plt
import itertools

#Instrukcje potrzebne do obsługi polskich znaków przez matplotlib
import sys
reload(sys)  
sys.setdefaultencoding('utf8')
plt.rc('font', family='Arial')

#Przyjmujemy 10000 próbek na grupę
n_experiment = 10000
n_control = 10000

p_experiment= 0.002
p_control = 0.001

se_experiment_sq = p_experiment*(1-p_experiment) / n_experiment
se_control_sq = p_control*(1-p_control) / n_control

Z = (p_experiment-p_control)/math.sqrt(se_experiment_sq+se_control_sq)

print Z

#Ten kod nie występuje na listingu, ale wspominamy o nim w tekście i jest potrzebny 
#do działania reszty kodu.
def get_z(n_experiment, n_control, p_experiment, p_control):
    var_experiment = p_experiment*(1-p_experiment) / n_experiment
    var_control = p_control*(1-p_control) / n_control
    Z = (p_experiment-p_control)/math.sqrt(var_experiment+var_control)
    return Z

experiment_array = np.linspace(100, 20000, 100)
control_array = np.linspace(100,20000,100)
experiment_probability_array = np.empty(100); experiment_probability_array.fill(0.002)
control_probability_array = np.empty(100); control_probability_array.fill(0.001)
data =  zip(experiment_array,control_array,experiment_probability_array,control_probability_array)
#Trzeba utworzyć odpowiednie parametry i połączyć je ze sobą.
z_results = [get_z(k[0],k[1],k[2],k[3]) for k in data]

plt.plot(experiment_array,z_results)
#Poziom ufności 95%
x_values = [0,20000]
y_values = [1.96,1.96]
plt.plot(x_values,y_values)
plt.text(x_values[0],y_values[0]+0.01,"95%")

#Poziom ufności 90%
x_values = [0,20000]
y_values = [1.645,1.645]
plt.plot(x_values,y_values)
plt.text(x_values[0],y_values[0]+0.01,"90%")

#Poziom ufności 80% (1.28)
x_values = [0,20000]
y_values = [1.28,1.28]
plt.plot(x_values,y_values)
plt.text(x_values[0],y_values[0]+0.01,"80%")

#Poziom ufności 70% (1.04)
x_values = [0,20000]
y_values = [1.04,1.04]
plt.plot(x_values,y_values)
plt.text(x_values[0],y_values[0]+0.01,"70%")

plt.xlabel("Liczba użytkowników w grupach A i B")
plt.ylabel("Wartość z")

plt.title("Liczba użytkowników względem wartości z dla stałej konwersji \n (0,001 dla A i 0,002 dla B)")
plt.show()

##Strategia bayesowska
#7.6
from scipy.stats import beta
import numpy as np
import matplotlib.pyplot as plt
import random
from operator import sub, div, add

class Bandit:
    def __init__(self,probability):
        self.probability=probability
    
    def pull_handle(self):
        if random.random()<self.probability:
            return 1
        else:
            return 0
        
    def get_prob(self):
        return self.probability

#7.7
def sample_distributions_and_choose(bandit_params):
    sample_array =  \
	[beta.rvs(param[0], param[1], size=1)[0] for param in bandit_params]
    return np.argmax(sample_array)

#7.8
def run_single_regret(bandit_list,bandit_params,plays):
    sum_probs_chosen=0
    opt=np.zeros(plays)
    chosen=np.zeros(plays)
    bandit_probs = [x.get_prob() for x in bandit_list]
    opt_solution = max(bandit_probs)
    for i in range(0,plays):
        index = sample_distributions_and_choose(bandit_params)
        sum_probs_chosen+=bandit_probs[index]
        if(bandit_list[index].pull_handle()):
            bandit_params[index]=\
		(bandit_params[index][0]+1,bandit_params[index][1])
        else:
            bandit_params[index]=\
		(bandit_params[index][0],bandit_params[index][1]+1)
        opt[i] = (i+1)*opt_solution
        chosen[i] = sum_probs_chosen
    regret_total = map(sub,opt,chosen)
    return regret_total

#7.9
#Najpierw określane są parametry
bandit_list = [Bandit(0.1),Bandit(0.3),Bandit(0.8)]
bandit_params = [(1,1),(1,1),(1,1)]

x = np.linspace(0,1, 100)
plt.plot(x, beta.pdf(x, bandit_params[0][0], bandit_params[0][1]),'-r*', alpha=0.6, label='Maszyna 1')
plt.plot(x, beta.pdf(x, bandit_params[1][0], bandit_params[1][1]),'-b+', alpha=0.6, label='Maszyna 2')
plt.plot(x, beta.pdf(x, bandit_params[2][0], bandit_params[2][1]),'-go', alpha=0.6, label='Maszyna 3')
plt.legend()
plt.xlabel("Prawdopodobieństwo wypłaty")
plt.ylabel("Gęstość prawdopodobieństwa przekonań")
plt.show()

#7.10
#Określanie poziomu straty dla jednego przebiegu
plays=1000
bandit_list = [Bandit(0.1),Bandit(0.3),Bandit(0.8)]
bandit_params = [(1,1),(1,1),(1,1)]

regret_total = run_single_regret(bandit_list,bandit_params,plays)
plt.plot(regret_total)
plt.title("Oczekiwany poziom strat w krokach eksperymentu")
plt.xlabel("Krok w eksperymencie")
plt.ylabel("Skumulowany oczekiwany poziom strat w danym kroku")
plt.show()

#7.11
#Wyświetlanie parametrów:
x = np.linspace(0,1, 100)
plt.plot(x, beta.pdf(x, bandit_params[0][0], bandit_params[0][1]),'-r*', alpha=0.6, label='Maszyna 1')
plt.plot(x, beta.pdf(x, bandit_params[1][0], bandit_params[1][1]),'-b+', alpha=0.6, label='Maszyna 2')
plt.plot(x, beta.pdf(x, bandit_params[2][0], bandit_params[2][1]),'-go', alpha=0.6, label='Maszyna 3')
plt.legend()
plt.xlabel("Prawdopodobieństwo wypłaty")
plt.ylabel("Gęstość prawdopodobieństwa wypłaty")
plt.show()

#7.12
#Wyświetlanie wielu poziomów strat na jednym wykresie
plays=1000
runs=100

for i in range(0,runs):
    bandit_list = [Bandit(0.1),Bandit(0.3),Bandit(0.8)]
    bandit_params = [(1,1),(1,1),(1,1)]
    regret_total = run_single_regret(bandit_list,bandit_params,plays)
    plt.plot(regret_total,label='%s'%i)

plt.title("Oczekiwany poziom straty w krokach eksperymentu")
plt.xlabel("Krok w eksperymencie")
plt.ylabel("Skumulowany oczekiwany poziom straty w danym kroku")
plt.show()

#7.13
#Wyświetlanie średniego poziomu straty w każdym kroku dla wielu przebiegów.
regret_sum=np.zeros(plays)

plays=1000
runs=100

for i in range(0,runs):
    bandit_list = [Bandit(0.1),Bandit(0.3),Bandit(0.8)]
    bandit_params = [(1,1),(1,1),(1,1)]
    regret_total = run_single_regret(bandit_list,bandit_params,plays)
    regret_sum=map(add,regret_sum, np.asarray(regret_total))

plt.plot(regret_sum/(runs*np.ones(plays)))
plt.title("Średni oczekiwany poziom straty w krokach na podstawie %s iteracji"%runs )
plt.xlabel("Krok w eksperymencie")
plt.ylabel("Średni łączny oczekiwany poziom straty w eksperymencie w danym kroku")
plt.show()

#Ten kod nie występuje w książce, jest jednak używany do generowania rysunków.
def plot_regret(p_a,p_b,p_c,marker_cycle):
    plays=1000
    runs=100
    regret_sum=np.zeros(plays)
    for i in range(0,runs):
        bandit_list = [Bandit(p_a),Bandit(p_b),Bandit(p_c)]
        bandit_params = [(1,1),(1,1),(1,1)]
        regret_total = run_single_regret(bandit_list,bandit_params,plays)
        regret_sum = map(add,regret_sum, np.asarray(regret_total))
    plt.plot(regret_sum/(runs*np.ones(plays)),label="%s,%s,%s"%(p_a,p_b,p_c),marker=marker_cycle.next(),markevery=50)
    plt.title("Średni oczekiwany poziom strat w krokach na podstawie %s iteracji"%runs)

def plot_regret_number_bandits(number_bandits,color_cycle,marker_cycle):
    plays=1000
    runs=100
    regret_sum=np.zeros(plays)
    for i in range(0,runs):
        bandit_list = []
        bandit_params = []
        for j in np.linspace(1,0,number_bandits, endpoint=False): #Maszyna o prawdopodobieństwie 0 jest pomijana
            bandit_list.append(Bandit(j))
            bandit_params.append((1,1))
        regret_total = run_single_regret(bandit_list,bandit_params,plays)
        regret_sum = map(add,regret_sum,np.asarray(regret_total))
    plt.plot(regret_sum/(runs*np.ones(plays)),label="Nr maszyny: %s"%(number_bandits),color=color_cycle.next(),marker=marker_cycle.next(),markevery=50)

#Eksperyment badający krzywą strat przy prawdopodobieńśtwach o podobnej wartości.
markers = itertools.cycle((',', '+', '.', 'o', '*')) 

plot_regret(0,0.5,1,markers)
plot_regret(0.1,.5,.9,markers)
plot_regret(.2,.5,.8,markers)
plot_regret(.3,.5,.7,markers)
plot_regret(.4,.5,.6,markers)

plt.legend()
plt.xlabel("Krok w eksperymencie")
plt.ylabel("Średni łączny oczekiwany poziom strat w danym kroku")
plt.show()

#Eksperyment sprawdzający krzywą strat po zmianie skali prawdopodobieństw.
plot_regret(0,0.05,0.1,markers)
plot_regret(0.01,0.05,0.09,markers)
plot_regret(0.02,0.05,0.08,markers)
plot_regret(0.03,0.05,0.07,markers)
plot_regret(0.04,0.05,0.06,markers)

plt.legend()
plt.xlabel("Krok w eksperymencie")
plt.ylabel("Średni skumulowany oczekiwany poziom strat w eksperymencie w danym kroku")
plt.show()


markers = itertools.cycle((',', '+', '.', 'o', '*', '^', 'D', 'h', 'p', 's')) 

#Eksperyment określający krzywą straty dla większej liczby maszyn.
color_cycle = itertools.cycle(plt.cm.spectral(np.linspace(0,1,10)))
plot_regret_number_bandits(1,color_cycle,markers)
plot_regret_number_bandits(2,color_cycle,markers)
plot_regret_number_bandits(3,color_cycle,markers)
plot_regret_number_bandits(4,color_cycle,markers)
plot_regret_number_bandits(5,color_cycle,markers)
plot_regret_number_bandits(6,color_cycle,markers)
plot_regret_number_bandits(7,color_cycle,markers)
plot_regret_number_bandits(8,color_cycle,markers)
plot_regret_number_bandits(9,color_cycle,markers)
plot_regret_number_bandits(10,color_cycle,markers)

plt.legend()
plt.xlabel("Krok w eksperymencie")
plt.ylabel("Średni skumulowany oczekiwany poziom strat w danym kroku")
plt.show()
print "Koniec"
