#!/usr/local/bin/python
# coding: utf-8
#6.3
import numpy as np
import matplotlib.pyplot as plt
import random
from sklearn.linear_model import perceptron

#Instrukcje potrzebne do obsługi polskich znaków przez matplotlib
import sys
reload(sys)  
sys.setdefaultencoding('utf8')
plt.rc('font', family='Arial')

#Konfigurowanie danych i wartości docelowych
data = np.array([[0,1],[0,0],[1,0],[1,1]])
target = np.array([0,0,0,1])

#6.4
p = perceptron.Perceptron(n_iter=100)
p_out = p.fit(data,target)
print p_out
msg = ("Współczynniki: %s, Punkt przecięcia: %s")
print msg % (str(p.coef_),str(p.intercept_)) 

#6.5
colors = np.array(['k','r'])
markers = np.array(['*','o'])
for data,target in zip(data,target):
	plt.scatter(data[0],data[1],s=100,c=colors[target],marker=markers[target])

#Trzeba wyznaczyć hiperpłaszczyznę dającą linię prostą w wyniku przecięcia dla z=0.
#Pamiętaj, że w ramach optymalizacji rozwiązywane jest równanie z=m1x + m2y + c.
#Jeśli chcesz zrozumieć linię prostą uzyskaną w wyniku przecięcia z płaszczyzną rzutowania (x,y) (dla z=0):
#0=m1x + m2y +c
#m2y -m1x -c
#y = -m1/m2x - c/m2

grad = -p.coef_[0][0]/p.coef_[0][1]
intercept = -p.intercept_/p.coef_[0][1]

x_vals = np.linspace(0,1)
y_vals = grad*x_vals + intercept
plt.plot(x_vals,y_vals)
plt.show()

#6.X RĘCZNIE zbudowany perceptron wielowarstwowy (NIE JEST PREZENTOWANY W KSIĄŻCE).
data = np.array([[0,1],[0,0],[1,0],[1,1]])
target = np.array([1,0,1,0])

colors = np.array(['k','r'])
markers = np.array(['*','o'])
for _data,_target in zip(data,target):
	plt.scatter(_data[0],_data[1],s=100,c=colors[_target],marker=markers[_target])

plt.xlabel('x_1')
plt.ylabel('x_2')

#Wyświetlanie ręcznie zbudowanego klasyfikatora logicznego
grad = -1
intercept = 0.5

x_vals = np.linspace(0,1)
y_vals = grad*x_vals + intercept
#plt.scatter(data[:,0],data[:,1],c=colors[target])
plt.plot(x_vals,y_vals,'b')

grad = -1
intercept = 1.5
x_vals = np.linspace(0,1)
y_vals = grad*x_vals + intercept
plt.plot(x_vals,y_vals,'r')

plt.xlabel('x_1')
plt.ylabel('x_2')

plt.text(0.8,-0.7,"x_2 = -x_1 + 0.5")
plt.text(0,1.65,"x_2 = -x_1 + 1.5")
plt.text(0.4,0.5,"y_1 = 1")
plt.text(0.8,1.5,"y_1 = 0")
plt.text(0,-0.5,"y_1 = 0")
plt.show()

#6.6
from pybrain.structure import LinearLayer, SigmoidLayer
from pybrain.datasets import SupervisedDataSet
from pybrain.supervised.trainers import BackpropTrainer
from pybrain.structure import FeedForwardNetwork
from pybrain.structure import FullConnection
from pybrain.structure.modules import BiasUnit

import random

#Tworzenie modułów sieci
net = FeedForwardNetwork()
inl = LinearLayer(2)
hidl = SigmoidLayer(2)
outl = LinearLayer(1)
b = BiasUnit()

#6.7
#Tworzenie połączeń
in_to_h = FullConnection(inl, hidl)
h_to_out = FullConnection(hidl, outl)
bias_to_h = FullConnection(b,hidl)
bias_to_out = FullConnection(b,outl)

#Dodawanie modułów do sieci
net.addInputModule(inl)
net.addModule(hidl);
net.addModule(b)
net.addOutputModule(outl)

#Dodawanie połączeń do sieci i sortowanie danych
net.addConnection(in_to_h)
net.addConnection(h_to_out)
net.addConnection(bias_to_h)
net.addConnection(bias_to_out)
net.sortModules()

#6.8
#Dane wejściowe
d = [(0,0),
     (0,1),
     (1,0),
     (1,1)]

#Wartości docelowe
c = [0,1,1,0]

data_set = SupervisedDataSet(2, 1) # 2 wejścia, 1 wyjście

random.seed()
for i in xrange(1000):
    r = random.randint(0,3)
    data_set.addSample(d[r],c[r])

backprop_trainer \
	= BackpropTrainer(net, data_set, learningrate=0.1)

for i in xrange(50):
    err = backprop_trainer.train()
    print "Iteracja %d, błąd: %.5f" % (i, err)

#6.9
print "[w(x_1,j=1),w(x_2,j=1),w(x_1,j=2),w(x_2,j=2)]: " + str(in_to_h.params)
print "[w(j=1,j=3),w(j=2,j=3)]: "+str(h_to_out.params)
print "[w(x_b,j=1),w(x_b,j=2)]: "+str(bias_to_h.params)
print "[w(x_b,j=3)]:" +str(bias_to_out.params)

#6.10
print "Aktywowanie dla wartości 0,0. Wynik: " + str(net.activate([0,0]))
print "Aktywowanie dla wartości 0,1. Wynik: " + str(net.activate([0,1]))
print "Aktywowanie dla wartości 1,0. Wynik: " + str(net.activate([1,0]))
print "Aktywowanie dla wartości 1,1. Wynik: " + str(net.activate([1,1]))


########################
# Od tego miejsca: maszyny RBM

# Pierwotni autorzy: Yann N. Dauphin, Vlad Niculae, Gabriel Synnaeve
# Licencja: BSD

import numpy as np
import matplotlib.pyplot as plt

from scipy.ndimage import convolve
from sklearn import linear_model, datasets, metrics
from sklearn.cross_validation import train_test_split
from sklearn.neural_network import BernoulliRBM
from sklearn.pipeline import Pipeline

#6.12
def nudge_dataset(X, Y):
    """
    Ten kod generuje zbiór danych pięciokrotnie większy od pierwotnego
    w wyniku przesunięcia obrazów o wymiarach 8x8 z X o 1 piksel   
    w lewo, w prawo, w górę i w dół
    """
    direction_vectors = [[[0, 1, 0],[0, 0, 0],[0, 0, 0]],
			[[0, 0, 0],[1, 0, 0],[0, 0, 0]],
			[[0, 0, 0],[0, 0, 1],[0, 0, 0]],
			[[0, 0, 0],[0, 0, 0],[0, 1, 0]]]
    shift = lambda x, w: convolve(x.reshape((8, 8)), mode='constant', weights=w).ravel()
    X = np.concatenate([X] + [np.apply_along_axis(shift, 1, X, vector) for vector in direction_vectors])
    Y = np.concatenate([Y for _ in range(5)], axis=0)
    return X, Y

#6.11
digits = datasets.load_digits()
X = np.asarray(digits.data, 'float32')
X, Y = nudge_dataset(X, digits.target)
X = (X - np.min(X, 0)) / (np.max(X, 0) + 0.0001)  # Skalowanie do przedziału 0-1
X_train, X_test, Y_train, Y_test = train_test_split(X, Y,test_size=0.2,random_state=0)

#6.13
# Używane modele
logistic = linear_model.LogisticRegression()
rbm = BernoulliRBM(random_state=0, verbose=True)

classifier = Pipeline(steps=[('rbm', rbm), ('logistic', logistic)])

###############################################################################
# Trening

# Hiperparametry. Zostały ustawione w wyniku walidacji krzyżowej z użyciem
# metody GridSearchCV. Tu pomijamy walidację krzyżową, aby przyspieszyć
# pracę.
rbm.learning_rate = 0.06
rbm.n_iter = 20
# Większa liczba komponentów zwykle pozwala zwiększyć skuteczność prognoz, ale
# kosztem wydłużenia czasu dopasowywania modelu do danych
rbm.n_components = 100
logistic.C = 6000.0

# Trening potoku obejmującego maszynę RBM i regresję logistyczną
classifier.fit(X_train, Y_train)

# Trening z użyciem regresji logistycznej
logistic_classifier = linear_model.LogisticRegression(C=100.0)
logistic_classifier.fit(X_train, Y_train)

#6.14
# Ocena
print("Regresja logistyczna z cechami z maszyny RBM:\n%s\n" % (
    metrics.classification_report(
        Y_test,
        classifier.predict(X_test))))

print("Regresja logistyczna dla cech opartych na samych pikselach:\n%s\n" % (
    metrics.classification_report(
        Y_test,
        logistic_classifier.predict(X_test))))


#6.15
plt.figure(figsize=(4.2, 4))
for i, comp in enumerate(rbm.components_):
    #print(i)
    #print(comp)
    plt.subplot(10, 10, i + 1)
    plt.imshow(comp.reshape((8, 8)), cmap=plt.cm.gray_r,interpolation='nearest')
    plt.xticks(())
    plt.yticks(())

plt.suptitle('Sto komponentów wyodrębnionych przez maszynę RBM', fontsize=16)
plt.subplots_adjust(0.08, 0.02, 0.92, 0.85, 0.08, 0.23)
plt.show()
