//START:defines
#define FLEX_TOO_HI   475
#define FLEX_TOO_LOW  465
#define ONBOARD_LED    13
#define FLEX_SENSOR     0
//END:defines

//START:variables
int bend_value  = 0;
byte bend_state = 0;
//END: variables

//START:setup
void setup()
{
    // na potrzeby komunikatw diagnostycznych w oknie portu szeregowego
    Serial.begin(9600);
    // ustawia wtyk dla wbudowanej diody LED
    pinMode(ONBOARD_LED, OUTPUT);
}
//END:setup

//START:SendWaterAlert
void SendWaterAlert(int bend_value, int bend_state)
{
    digitalWrite(ONBOARD_LED, bend_state ? HIGH : LOW);
    if (bend_state)
        Serial.print("Poziom wody przekroczy prg, bend_value=");
    else
        Serial.print("Poziom wody wrci do normalnego stanu, bend_value=");
    Serial.println(bend_value);
}
//END:SendWaterAlert

//START:main_loop
void loop() 
{
    // czeka sekund w kadej iteracji ptli
    delay(1000);
    // sprawdza napicie na wtyku FLEX_SENSOR
    bend_value = analogRead(FLEX_SENSOR);

    // wysya warto zmiennej bend_value do portu szeregowego w celu wyznaczenia wartoci bazowej
    // ten wiersz naley zamieni w komentarz po wyznaczeniu wartoci bazowej
    // limity zostay zdefiniowane
    Serial.print("bend_value=");
    Serial.println(bend_value);	

    switch (bend_state)
    {
    case 0: // warto zmiennej bend_value nie przekracza grnego ani dolnego progu
        if (bend_value >= FLEX_TOO_HI || bend_value <= FLEX_TOO_LOW)
        {
            bend_state = 1;
            SendWaterAlert(bend_value, bend_state);
        }
        break;
    case 1: // warto zmiennej bend_value przekracza grny lub dolny prg
        if (bend_value < FLEX_TOO_HI && bend_value > FLEX_TOO_LOW)
        {
            bend_state = 0;
            SendWaterAlert(bend_value, bend_state);
        }
        break;
    }
}
//END:main_loop