//START:defines
#define SEED             500
#define ONBOARD_LED       13
#define PHOTOCELL_SENSOR   0
//END:defines
//START:variables
int seed_value  = 0;
byte seed_state = 0;
//END:variables
//START:setup
void setup()
{
    // na potrzeby komunikatw diagnostycznych w oknie portu szeregowego
    Serial.begin(9600);

    // ustawia wtyk dla wbudowanej diody LED
    pinMode(ONBOARD_LED, OUTPUT);
}
//END:setup

//START:SendSeedAlert
void SendSeedAlert(int seed_value, int seed_state)
{
    digitalWrite(ONBOARD_LED, seed_state ? HIGH : LOW);
    if (seed_state)
        Serial.print("Uzupenij ziarno, seed_value=");
    else
        Serial.print("Karma uzupeniona, seed_value=");
    Serial.println(seed_value);
}
//END:SendSeedAlert

//START:main_loop
void loop() {
    // czeka sekund w kadej iteracji ptli
    delay(1000);

    // sprawdza warto fotokomrki ledzcej poziom ziarna
    seed_value = analogRead(PHOTOCELL_SENSOR);

    switch (seed_state)
    {
    case 0: // pojemnik na ziarno zosta napeniony
        if (seed_value >= SEED)
        {
            seed_state = 1;
            SendSeedAlert(seed_value, seed_state);
        }
        break;
    case 1: // pojemnik na ziarno jest pusty
        if (seed_value < SEED)
        {
            seed_state = 0;
            SendSeedAlert(seed_value, seed_state);
        }
        break;
    }
}
//END:main_loop