//START:includes
#include <CapSense.h>
//END:includes

//START:defines
#define ON_PERCH  1500
#define CAP_SENSE   30
#define ONBOARD_LED 13
//END:defines

//START:variables
CapSense foil_sensor = CapSense(10,7); // czujnik pojemnociowy
                                       // rezystor mostkujcy wtyki cyfrowe nr 10 i 7
                                       // przewd poczony z rezystorem od strony wtyku nr 7
int perch_value  = 0;
byte perch_state = 0;
//END:variables

//START:setup
void setup()
{
    // na potrzeby komunikatw diagnostycznych w oknie portu szeregowego
    Serial.begin(9600);

    // ustawia wtyk dla wbudowanej diody LED
    pinMode(ONBOARD_LED, OUTPUT);
}
//END:setup

//START:SendPerchAlert
void SendPerchAlert(int perch_value, int perch_state)
{
    digitalWrite(ONBOARD_LED, perch_state ? HIGH : LOW);
    if (perch_state)
        Serial.print("Zdarzenie ldowania na grzdzie, perch_value=");
    else
        Serial.print("Zdarzenie opuszczenia grzdy, perch_value=");
    Serial.println(perch_value);
}
//END:SendPerchAlert

//START:main_loop
void loop() {
    // czeka sekund w kadej iteracji ptli
    delay(1000);

    // pobiera warto czujnika pojemnociowego
    perch_value = foil_sensor.capSense(CAP_SENSE);

    switch (perch_state)
    {
    case 0: // aden ptak nie siedzi obecnie na grzdzie
        if (perch_value >= ON_PERCH)
        {
            perch_state = 1;
            SendPerchAlert(perch_value, perch_state);
        }
        break;
    case 1: // jaki ptak siedzi teraz na grzdzie
        if (perch_value < ON_PERCH)
        {
            perch_state = 0;
            SendPerchAlert(perch_value, perch_state);
        }
        break;
    }
}
//END:main_loop