from datetime import datetime # <callout id="code.packagedelivery.py.import"/>
import packagetrack
from packagetrack import Package
import serial
import smtplib
import sqlite3
import time
import os
import sys
# Nawizuje poczenie z portem szeregowym
XBeePort = serial.Serial('/dev/tty.URZDZENIE_SZEREGOWE', \
  baudrate = 9600, timeout = 1) # <callout id="code.packagedelivery.py.xbee"/>

def send_email(subject, message): # <callout id="code.packagedelivery.py.send_email"/>
  recipient = 'ADRESAT_POCZTY@DOMENA.PL'
  gmail_sender = 'NAZWA_KONTA_GMAIL@gmail.com'
  gmail_password = 'HASO_DO_KONTA_GMAIL'
  
  # Nawizuje bezpieczne poczenie TLS z bram SMTP usugi Gmail
  gmail_smtp = smtplib.SMTP('smtp.gmail.com',587)
  gmail_smtp.ehlo()
  gmail_smtp.starttls()
  gmail_smtp.ehlo

  # Loguje si do usugi Gmail
  gmail_smtp.login(gmail_sender, gmail_password)

  # Formatuje wiadomo
  mail_header = 'To:' + recipient + '\n' + 'From: ' + gmail_sender + '\n' \
      + 'Subject: ' + subject + '\n'
  message_body = message
  mail_message = mail_header + '\n ' + message_body + ' \n\n'

  # Wysya sformatowan wiadomo
  gmail_smtp.sendmail(gmail_sender, recipient, mail_message)
  print("Wiadomo zostaa wysana")

  # Zamyka poczenie
  gmail_smtp.close()

def process_message(msg): # <callout id="code.packagedelivery.py.process_message"/>
  try:
    # Naley pamita o koniecznoci uycia prawidowej cieki do pliku
    # packagedelivery.sqlite
    connection = sqlite3.connect("packagedelivery.sqlite")
    cursor = connection.cursor()

    # Uzyskuje i odpowiednio formatuje biec dat i godzin
    timestamp = datetime.now().strftime("%Y-%m-%d %H:%M:%S")

    sqlstatement = "INSERT INTO delivery (id, time, event) \
    VALUES(NULL, \"%s\", \"%s\")" % (timestamp, msg)
    cursor.execute(sqlstatement)
    connection.commit()
    cursor.close()
  except:
    print("Wystpi problem podczas prby dostpu do tabeli delivery " \
    + "w bazie danych packagedelivery")

  if (msg == "Delivery"):
    
    # Czeka 5 minut (300 sekund) przed sprawdzeniem stanu przesyki w systemach firm kurierskich
    time.sleep(300)

    try:
      connection = sqlite3.connect("packagedelivery.sqlite")
      cursor = connection.cursor()
      cursor.execute('SELECT * FROM tracking WHERE '\
      + 'delivery_status=0')
      results = cursor.fetchall()
      message = ""
	  
      for x in results:
        tracking_number = str(x[1])
        description = str(x[2])
        print tracking_number

        package = Package(tracking_number)
        info = package.track()
        delivery_status = info.status
        delivery_date = str(info.delivery_date)

        if (delivery_status.lower() == 'delivered'):
          sql_statement = 'UPDATE tracking SET \
          delivery_status = "1", delivery_date = \
          "' + delivery_date + \ 
          '" WHERE tracking_number = "' \
           + tracking_number + '";'
          cursor.execute(sql_statement)
          connection.commit()
          message = message + description \
          + ' paczka oznaczona numerem ' \
          + tracking_number \
          + ' zostaa dostarczona dnia ' \
          + delivery_date +'\n\n'

      # Zamyka kursor
      cursor.close()

      # Potwierdzono dostarczenie przesyki, mona wysa wiadomo poczty elektronicznej
      if (len(message) > 0):
        print message
        send_email('Potwierdzenie dostarczenia przesyki', message)
      else:
        send_email('Wykryto dostarczon przesyk', 'System ' \
        + 'wykry zdarzenie dostarczenia paczki, ' \
        + 'jednak dla adnej ze ledzonych przesyek z niepotwierdzonym ' \
        + 'numerem (zarejestrowanych w bazie danych) ' \
        + 'nie potwierdzono dostarczenia do adresata ' \
        + 'w systemie firmy kurierskiej.')
    except:
      print("Wystpi problem podczas prby dostpu do tabeli tracking " \
      + "w bazie danych packagedelivery")

  else:
    send_email('Zabrano paczk', 'Wykryto zdarzenie zabrania paczki.')

if sys.platform == "win32": # <callout id="code.packagedelivery.py.main_loop"/>
    os.system("cls")
else:
    os.system("clear")

print("Wykrywacz dostarczonych paczek czeka na zdarzenia...\n")
try:
  while 1:
    # Nasuchuje znakw przychodzcych do moduu radiowego XBee
    XBee_message = XBeePort.readline()

    # W zalenoci od rodzaju otrzymanego komunikatu
    # rejestruje zdarzenie w bazie danych i przeszukuje ledzone przesyki
    if "Delivery" in XBee_message:
      # Uzyskuje i odpowiednio formatuje biec dat i godzin
      timestamp = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
      print("Wykryto zdarzenie dostarczenia paczki - " + timestamp)
      process_message("Delivery")

    if "Empty" in XBee_message:
      # Uzyskuje i odpowiednio formatuje biec dat i godzin
      timestamp = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
      print("Wykryto zdarzenie zabrania paczki - " + timestamp)
      process_message("Empty")

except KeyboardInterrupt:
  print("\nWykrywacz dostarczonych paczek koczy dziaanie.\n")
  pass
