//START:includes
#include <avr/pgmspace.h>
#include "util.h"
#include "MediaPlayer.h"
#include <ServoTimer2.h> 
//END:includes 

//START:variables
int ledPin        = 13;  // wbudowana dioda LED
int inputPin      = 12;  // wtyk wejciowy dla czujnika ruchu PIR
int pirStatus     = LOW; // warto LOW reprezentuje prg braku wykrytego ruchu
int pirValue      = 0;   // zmienna uywana do przechowywania odczytanego statusu wtyku inputPin
int servoposition = 0;   // pocztkowe pooenie serwomotoru
//END:variables

//START:objects
ServoTimer2 theservo;    // tworzy obiekt theservo klasy ServoTimer2
MediaPlayer mediaPlayer; // tworzy obiekt mediaPlayer
                         // klasy MediaPlayer
//END:objects

//START:setup
void setup() {
  pinMode(ledPin, OUTPUT);   // ustawia tryb pinMode OUTPUT dla wbudowanej diody LED
  pinMode(inputPin, INPUT);  // ustawia tryb INPUT dla wtyku inputPin (czujnika ruchu PIR)
  theservo.attach(7);        // czy cyfrowe wyjcie serwomotoru z wtykiem nr 7
  randomSeed(analogRead(0)); // przekazuje warto pocztkow dla generatora liczb losowych platformy Arduino
  Serial.begin(9600);
}
//END:setup
 
//START:main_loop
void loop(){
  pirValue = digitalRead(inputPin);  // sprawdza warto czujnika PIR
  if (pirValue == HIGH) {            // jeli wykryto ruch
    digitalWrite(ledPin, HIGH);        // wcza wbudowan diod LED
    if (pirStatus == LOW) {            // wymusza ruch serwomotoru
      Serial.println("Wykryto ruch");
      // generuje liczb losow z przedziau od 1 do 5, aby wybra przypadkowy plik dwikowy,
      // po czym odtwarza ten plik i wymusza obrt serwomotoru o liczb stopni zalen od wylosowanej wartoci
      switch (random(1,6)) {
        case 1:
          Serial.println("Odtwarzanie pliku 1.WAV");
          theservo.write(1250);
          mediaPlayer.play("1.WAV");
          break;
        case 2:
          Serial.println("Odtwarzanie pliku 2.WAV");
          theservo.write(1400);
          mediaPlayer.play("2.WAV");
          break;
        case 3:
          Serial.println("Odtwarzanie pliku 3.WAV");
          theservo.write(1600);
          mediaPlayer.play("3.WAV");
          break;
        case 4:
          Serial.println("Odtwarzanie pliku 4.WAV");
          theservo.write(1850);
          mediaPlayer.play("4.WAV");
          break;
        case 5:
          Serial.println("Odtwarzanie pliku 5.WAV");
          theservo.write(2100);
          mediaPlayer.play("5.WAV");
          break;
      }

      delay(1000);          // czeka sekund
      theservo.write(1000); // przywraca pocztkow pozycj serwomotoru
      pirStatus = HIGH;     // ustawia warto HIGH flagi pirStatus, aby zatrzyma
                            // dziaanie mechanizmu
    }
  } else {
    digitalWrite(ledPin, LOW); // wycza wbudowan diod LED
    if (pirStatus == HIGH){
      Serial.println("Brak ruchu");
      mediaPlayer.stop();
      pirStatus = LOW;  // ustawia warto LOW flagi pirStatus, aby
                        // czujnik by przygotowany na zdarzenie ruchu
    }
  }
}
//END:main_loop