/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.datatransfer;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.harmony.awt.datatransfer.DataProvider;
import org.apache.harmony.awt.datatransfer.RawBitmap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSource
implements DataProvider {
    private DataFlavor[] flavors;
    private List<String> nativeFormats;
    protected final Transferable contents;

    public DataSource(Transferable contents) {
        this.contents = contents;
    }

    private boolean isHtmlFlavor(DataFlavor f) {
        return "html".equalsIgnoreCase(f.getSubType());
    }

    protected DataFlavor[] getDataFlavors() {
        if (this.flavors == null) {
            this.flavors = this.contents.getTransferDataFlavors();
        }
        return this.flavors;
    }

    @Override
    public String[] getNativeFormats() {
        return this.getNativeFormatsList().toArray(new String[0]);
    }

    public List<String> getNativeFormatsList() {
        if (this.nativeFormats == null) {
            DataFlavor[] flavors = this.getDataFlavors();
            this.nativeFormats = DataSource.getNativesForFlavors(flavors);
        }
        return this.nativeFormats;
    }

    private static List<String> getNativesForFlavors(DataFlavor[] flavors) {
        ArrayList<String> natives = new ArrayList<String>();
        SystemFlavorMap flavorMap = (SystemFlavorMap)SystemFlavorMap.getDefaultFlavorMap();
        int i = 0;
        while (i < flavors.length) {
            List<String> list = flavorMap.getNativesForFlavor(flavors[i]);
            for (String nativeFormat : list) {
                if (natives.contains(nativeFormat)) continue;
                natives.add(nativeFormat);
            }
            ++i;
        }
        return natives;
    }

    private String getTextFromReader(Reader r) throws IOException {
        int len;
        StringBuilder buffer = new StringBuilder();
        char[] chunk = new char[1024];
        while ((len = r.read(chunk)) > 0) {
            buffer.append(chunk, 0, len);
        }
        return buffer.toString();
    }

    private String getText(boolean htmlOnly) {
        DataFlavor[] flavors = this.contents.getTransferDataFlavors();
        int i = 0;
        while (i < flavors.length) {
            DataFlavor f = flavors[i];
            if (f.isFlavorTextType() && (!htmlOnly || this.isHtmlFlavor(f))) {
                try {
                    if (String.class.isAssignableFrom(f.getRepresentationClass())) {
                        return (String)this.contents.getTransferData(f);
                    }
                    Reader r = f.getReaderForText(this.contents);
                    return this.getTextFromReader(r);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        return null;
    }

    @Override
    public String getText() {
        return this.getText(false);
    }

    @Override
    public String[] getFileList() {
        try {
            List list = (List)this.contents.getTransferData(DataFlavor.javaFileListFlavor);
            return list.toArray(new String[list.size()]);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getURL() {
        try {
            URL url = (URL)this.contents.getTransferData(urlFlavor);
            return url.toString();
        }
        catch (Exception url) {
            try {
                URL url2 = (URL)this.contents.getTransferData(uriFlavor);
                return url2.toString();
            }
            catch (Exception url2) {
                try {
                    URL url3 = new URL(this.getText());
                    return url3.toString();
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
    }

    @Override
    public String getHTML() {
        return this.getText(true);
    }

    @Override
    public RawBitmap getRawBitmap() {
        DataFlavor[] flavors = this.contents.getTransferDataFlavors();
        int i = 0;
        while (i < flavors.length) {
            DataFlavor f = flavors[i];
            Class<?> c = f.getRepresentationClass();
            if (c != null && Image.class.isAssignableFrom(c) && (f.isMimeTypeEqual(DataFlavor.imageFlavor) || f.isFlavorSerializedObjectType())) {
                try {
                    Image im = (Image)this.contents.getTransferData(f);
                    return this.getImageBitmap(im);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ++i;
        }
        return null;
    }

    private RawBitmap getImageBitmap(Image im) {
        BufferedImage bi;
        if (im instanceof BufferedImage && (bi = (BufferedImage)im).getType() == 1) {
            return this.getImageBitmap32(bi);
        }
        int width = im.getWidth(null);
        int height = im.getHeight(null);
        if (width <= 0 || height <= 0) {
            return null;
        }
        BufferedImage bi2 = new BufferedImage(width, height, 1);
        Graphics gr = bi2.getGraphics();
        gr.drawImage(im, 0, 0, null);
        gr.dispose();
        return this.getImageBitmap32(bi2);
    }

    private RawBitmap getImageBitmap32(BufferedImage bi) {
        int[] buffer = new int[bi.getWidth() * bi.getHeight()];
        DataBufferInt data = (DataBufferInt)bi.getRaster().getDataBuffer();
        int bufferPos = 0;
        int bankCount = data.getNumBanks();
        int[] offsets = data.getOffsets();
        int i = 0;
        while (i < bankCount) {
            int[] fragment = data.getData(i);
            System.arraycopy(fragment, offsets[i], buffer, bufferPos, fragment.length - offsets[i]);
            bufferPos += fragment.length - offsets[i];
            ++i;
        }
        return new RawBitmap(bi.getWidth(), bi.getHeight(), bi.getWidth(), 32, 0xFF0000, 65280, 255, buffer);
    }

    @Override
    public byte[] getSerializedObject(Class<?> clazz) {
        try {
            DataFlavor f = new DataFlavor(clazz, null);
            Serializable s = (Serializable)this.contents.getTransferData(f);
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            new ObjectOutputStream(bytes).writeObject(s);
            return bytes.toByteArray();
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    public boolean isNativeFormatAvailable(String nativeFormat) {
        return this.getNativeFormatsList().contains(nativeFormat);
    }
}

