from microdot_asyncio import Microdot, Response
from microdot_utemplate import init_templates
from microdot_utemplate import render_template
import machine, network, time
import dht

# konfiguracja czujnika DHT
dhtName = "DHT22" # typ czujnika DHT
dhtPin = 15       # numer GPIO dla linii sygnałowej DAT
if dhtName == "DHT11":
  sensor = dht.DHT11(machine.Pin(pinDHT))
elif dhtName == "DHT22":
  sensor = dht.DHT22(machine.Pin(dhtPin))
else:
  print("Problem z aktywacją czujnika DHT")

# połączenie się z siecią WiFi
wifi = network.WLAN(network.STA_IF);
wifi.active(True)
wifi.connect('nazwa sieci WiFi', 'hasło')

print('Łączę się z siecią WiFi ', end = '')
while True: # czekaj na połączenie
  if wifi.isconnected():
    break
  print('.', end = '')
  time.sleep(1)

print(' gotowe!')
print('Adres IP: ' + wifi.ifconfig()[0])

app = Microdot() # utwórz obiekt aplikacji
Response.default_content_type = 'text/html' # domyślny typ wysyłanych danych
init_templates('/') # lokalizacja plików z szablonem strony – katalog główny projektu

# definicja tras rutingu
@app.route('/') # strona główna
async def index(request):
  data = readSensor().split(',')
  return render_template('index.tpl', data[0], data[1], dhtName)

@app.route('/data') # adres URL do odczyt danych z czujnika DHT
async def data(request):
  return readSensor()

@app.route('/shutdown')
async def shutdown(request):
  request.app.shutdown()
  return 'Wyłączam serwer WWW ...'

@app.errorhandler(404)
async def notFound(request):
  return 'Strona nie istnieje :('

# odczyt danych z czujnika DHT
def readSensor():
  temp = hum = 0
  try:
    sensor.measure() # wykonaj pomiar
    temp = sensor.temperature()
    hum = sensor.humidity()
    if (isinstance(temp, float) and isinstance(hum, float)) or (isinstance(temp, int) and isinstance(hum, int)):
      return '{0:3.1f},{1:3.1f}'.format(temp, hum)
    else:
      return '0.0,0.0' # błąd odczytu z czujnika DHT
  except OSError as e:
    return '0.0,0.0' # brak komunikacji z czujnikiem DHT

app.run(port = 80, debug = True) # uruchom serwer WWW
