#define mDNS_ENABLE true         // czy aktywować usługę multicast DNS?
#define FS_ENABLE true           // czy aktywować obsługę systemu plików?

// dołącz obsługę WiFi w zależności od zastosowanego układu ESP
#if defined(ESP8266)
  #include <ESP8266WiFi.h>       // funkcje sieciowe dla układu ESP8266
  #if mDNS_ENABLE
    #include <ESP8266mDNS.h>     // włącz obsługę multicast DNS
    #define mDNS_host "esp8266"  // nazwa w sieci lokalnej - http://esp8266.local
  #endif
#elif defined(ESP32)
  #include <WiFi.h>              // funkcje sieciowe dla układu ESP32
  #if mDNS_ENABLE
    #include <ESPmDNS.h>         // włącz obsługę multicast DNS
    #define mDNS_host "esp32"    // nazwa w sieci lokalnej - http://esp32.local
  #endif
#endif

#if FS_ENABLE
  #include <LittleFS.h>          // dołącz obsługę systemu plików LittleFS
#endif
#include <aWOT.h>                // dołącz bibliotekę frameworku aWOT

WiFiServer Server(80);           // utwórz obiekt serwera WWW na porcie 80
Application app;                 // i obiekt aplikacji obsługującej połączenia WWW

// dostęp do sieci WiFi
char wifi_ssid[]   = "nazwa sieci WiFi";
char wifi_passwd[] = "hasło";

#define serialSpeed 115200 // prędkość transmisji UART

// obsługa żądania GET /
void pageIndex(Request &req, Response &res) {
  res.print(F("Serwer WWW aktywny!"));
}

void setup()
{
  Serial.begin(serialSpeed);

  // połącz z punktem dostępowym
  Serial.print(F("Łączę się z siecią WiFi "));
  WiFi.begin(wifi_ssid, wifi_passwd);

  while (WiFi.status() != WL_CONNECTED) { // czekaj na połączenie
    delay(500);
    Serial.print(F("."));
  }

  Serial.println(F(" gotowe!"));

  #if mDNS_ENABLE
    // aktywuj usługę multicast DNS
    if (MDNS.begin(mDNS_host)) { 
      Serial.println(F("Usługa mDNS aktywna."));
    }
  #endif

  #if FS_ENABLE
    // aktywuj obsługę systemu plików LittleFS
    Serial.print(F("Inicjalizacja systemu plików LittleFS ..."));
    if (LittleFS.begin()){
      Serial.println(F(" gotowe!"));
    } else {
      Serial.println(F(" coś poszło nie tak :("));
    }
  #endif

  // obsługa żądań klienta WWW przez framework aWOT
  app.get("/", &pageIndex); // obsługa żądania GET /
  Server.begin();           // uruchom serwer WWW
  
  Serial.println(F("Serwer WWW uruchomiony."));
  Serial.println(F("Otwórz w przeglądarce jeden z poniższych adresów URL:"));
  Serial.print(F("=> http://"));
  Serial.println(WiFi.localIP());
  #if mDNS_ENABLE
    Serial.print(F("=> http://"));
    Serial.print(mDNS_host);
    Serial.println(F(".local"));
  #endif
}

void loop() 
{
  WiFiClient client = Server.available();

  if (client.connected()) { // czekaj na połączenia klientów
    app.process(&client);   // obsłuż żądanie klienta
    client.stop();          // i zamknij połączenie
  }

  #if defined(ESP8266)
    MDNS.update();          // aktualizuj nazwę urządzenia w sieci lokalnej
  #endif
}
