#include <SPI.h>         // obsługa interfejsu SPI,
#include <Ethernet.h>    // obsługa modułu sieci Ethernet
#include <EthernetUdp.h> // i protokołu UDP,
#include <SD.h>          // obsługa czytnika kart SD,
#include "DHT.h"         // czujnika DHT,
#include <TimeLib.h>     // i serwera NTP

#define serialSpeed 115200 // prędkość transmisji UART

#define DHTPIN 7      // numer GPIO dla linii sygnałowej DAT w DHT11
#define DHTTYPE DHT11 // typ czujnika DHT
/*
#define DHTTYPE DHT21 // DHT 21 (AM2301)
#define DHTTYPE DHT22 // DHT 22 (AM2302), AM2321
*/

#define SPI_SS 4 // numer GPIO dla linii SS (CS), 10 zarezerwowane jest dla W5100

DHT dht(DHTPIN, DHTTYPE); // obiekt obsługujący czujnik DHT
File dataFile;            // i czytnik kart SD

EthernetUDP Udp;
byte mac[] = {0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED}; // MAC adres modułu sieciowego
IPAddress timeServer(162, 159, 200, 1); // pool.ntp.org
unsigned int portUDP = 8888;  // numer portu, na którym będą odbierane pakiety NTP
const int timeZone = 2; // strefa czasowa
const long eventTime = 10000; // co ile milisekund aktualizować dane?
unsigned long previousTime = 0;

void setup() {
  Serial.begin(serialSpeed);
  
  Serial.print(F("Inicjalizacja czytnika kart SD ... "));
  if (!SD.begin(SPI_SS)) { // uzyskaj dostęp do karty SD
    Serial.println(F("wstąpił problem, czy karta SD jest w czytniku?"));
    while(1); // włóż kartę SD do czytnika i uruchom program ponownie
  }
  Serial.println(F("gotowe!"));

  Serial.print(F("Inicjalizacja modułu sieci Ethernet ... "));
  if (Ethernet.begin(mac) == 0) {
    Serial.println(F("wstąpił problem z konfiguracją DHCP"));
    while(1);
  }
  Serial.print(F("gotowe! IP = "));
  Serial.println(Ethernet.localIP());

  Udp.begin(portUDP);
  Serial.println("Synchronizacja daty z serwerem NTP ... ");
  setSyncProvider(getNtpTime); // obsługa połączeń z serwerem NTP
  setSyncInterval(300); // odświeżaj czas z serwera NTP co 5 minut

  Serial.print(F("Inicjalizacja czujnika DHT ... "));
  dht.begin(); // aktywuj odczyt z czujnika DHT
  Serial.println(F("gotowe!"));

  Serial.print(F("Aktualizacja danych co "));
  Serial.print(eventTime / 1000);
  Serial.println(F(" sekund."));  
}

void loop() {
  unsigned long currentTime = millis();

  if (currentTime - previousTime >= eventTime)
  {    
    previousTime = currentTime;

    String date = getDate();

    float temp = dht.readTemperature(); // odczyt temperatury
    float hmd = dht.readHumidity();     // i wilgotności

    Serial.print(date);
    Serial.print(F(",T:"));
    Serial.print(temp);
    Serial.print(F("°C, H: "));
    Serial.print(hmd);
    Serial.print(F("% | zapis danych na karcie SD ... "));
    
    updateFile(date, temp, hmd); // wywołaj funkcję zapisującą dane na kartę SD
    
    Serial.println(F("gotowe!"));
  } 
}

void updateFile(String date, float temp, float hmd) {
    dataFile = SD.open("data.txt", FILE_WRITE); // otwórz (lub utwórz) plik do zapisu
    if (dataFile) { // jeśli dostęp do pliku jest możliwy, zapisz dane
      dataFile.print(date);
      dataFile.print(",");
      dataFile.print(temp);
      dataFile.print(",");
      dataFile.println(hmd);
    }
    dataFile.close(); // zamknij dostęp do pliku
}

String getDate() { // zwróć tekst z datą w formacie YYYY-MM-DD GG:MM:SS
  String date = "";
  date.concat(year());
  date.concat("-");
  date.concat(month());
  date.concat("-");
  date.concat(day());
  date.concat(" ");
  date.concat(hour());
  date.concat(":");
  date.concat(minute());
  date.concat(":");
  date.concat(second());

  return date;
}

// obsługa protokołu NTP
const int NTP_PACKET_SIZE = 48; // czas NTP zawarty jest w pierwszych 48 bajtach
byte packetBuffer[NTP_PACKET_SIZE]; // bufor na dane pakietów NTP

time_t getNtpTime()
{
  while (Udp.parsePacket() > 0) ; // odrzuć wcześniejsze pakiety danych
  Serial.print(F("Wysyłam zapytanie o aktualny czas do serwera NTP ... "));
  sendNTPpacket(timeServer);
  uint32_t beginWait = millis();
  while (millis() - beginWait < 1500) {
    int size = Udp.parsePacket();
    if (size >= NTP_PACKET_SIZE) {
      Serial.println("gotowe!");
      Udp.read(packetBuffer, NTP_PACKET_SIZE); // zapisz w buforze odebrany pakiet
      unsigned long secsSince1900;
      // przekonwertuj 4 bajty, zaczynając od pozycji 40, na liczbę całkowitą
      secsSince1900 =  (unsigned long)packetBuffer[40] << 24;
      secsSince1900 |= (unsigned long)packetBuffer[41] << 16;
      secsSince1900 |= (unsigned long)packetBuffer[42] << 8;
      secsSince1900 |= (unsigned long)packetBuffer[43];
      return secsSince1900 - 2208988800UL + timeZone * SECS_PER_HOUR;
    }
  }
  Serial.println("brak odpowiedzi z serwera NTP :(");
  return 0; // zwróć 0, jeśli nie można pobrać informacji z serwera NTP
}

void sendNTPpacket(IPAddress &address)
{
  // zeruj bufor
  memset(packetBuffer, 0, NTP_PACKET_SIZE);

  // przygotuj zapytanie do serwera NTP
  packetBuffer[0] = 0b11100011;
  packetBuffer[1] = 0;
  packetBuffer[2] = 6;
  packetBuffer[3] = 0xEC;
  packetBuffer[12] = 49;
  packetBuffer[13] = 0x4E;
  packetBuffer[14] = 49;
  packetBuffer[15] = 52;

  // wyślij zapytanie do serwera NTP               
  Udp.beginPacket(address, 123); // serwer NTP nasłuchuje na porcie 123
  Udp.write(packetBuffer, NTP_PACKET_SIZE);
  Udp.endPacket();
}
