#include <GSMSimSMS.h>
#include <SoftwareSerial.h>               

#define PIN_RX  10
#define PIN_TX  11
#define PIN_RESET 2

#define serialSpeed 9600 // prędkość transmisji UART

static volatile int smsCnt = 0; // licznik odebranych komunikatów

SoftwareSerial sim800l(PIN_RX, PIN_TX);
GSMSimSMS sms(sim800l, PIN_RESET);

#define SIM_PIN "0000" // numer PIN dla karty SIM

#define ADMIN_SEND  true           // czy wysłać powiadomienie do admina?
#define ADMIN_PHONE "+48123456789" // na jaki numer telefonu?

#include "DHT.h" // dołącz obsługę modułu DHT

#define DHTPIN 7      // numer GPIO dla linii sygnałowej DAT
#define DHTTYPE DHT11 // typ czujnika DHT
/*
#define DHTTYPE DHT11
#define DHTTYPE DHT21 // DHT 21 (AM2301)
#define DHTTYPE DHT22 // DHT 22 (AM2302), AM2321
*/

DHT dht(DHTPIN, DHTTYPE); // obiekt obsługujący czujnik DHT

float alarmTemp = 25.0; // wartość krytyczna temperatury 
float alarmHmd = 75.0;  // i wilgotności 

int board_id = 1; // identyfikator urządzenia

const long eventSMS = 300000; // wysyłaj SMS nie częściej niż co 5 minut
unsigned long previousSMS = eventSMS;

const long eventTime = 10000; // sprawdzaj dane z czujnika DHT co 10 sekund
unsigned long previousTime = eventTime;

bool sendSMS(String recipientno, String headerText = "");

void setup()
{
  Serial.begin(serialSpeed);
  
  Serial.print(F("Inicjalizacja czujnika DHT ... "));
  dht.begin();
  Serial.println(F("gotowe!"));

  // inicjalizacja modułu GSM
  Serial.print(F("Inicjalizacja modułu GSM ... "));
  sim800l.begin(serialSpeed);

  while(!sim800l) {
    ; // czekaj na połączenie się z modułem GSM
  }
  
  sms.init();
  Serial.println(F("gotowe!"));
  delay(1000);

  // czy karta SIM jest w module GSM?
  Serial.print(F("Sprawdzam kartę SIM ..."));
  while (!sms.isSimInserted()) { 
    delay(1000);
    Serial.print(F("."));
  }
  Serial.println(F(" wykryta!"));

  // czy wymagany jest numer PIN?
  if (sms.pinStatus() > 0) {
    if (sms.pinStatus() == 1) {
      Serial.print(F("Wprowadzam PIN do karty SIM ... "));
      if (sms.enterPinCode(SIM_PIN)) {
        Serial.println(F("gotowe!"));        
        // czas na wprowadzenie numeru PIN i zarejestrowanie karty SIM w sieci GSM
        delay(5000);
      } else {
        Serial.println(F("coś poszło nie tak :("));
      }
    } else {
      Serial.println(F("Sprawdź kartę SIM!"));    
      while(1) {
        ; // sprawdź czy karta SIM działa poprawnie
      }
    }
  }

  // aktywacja funkcji sieciowych
  Serial.print(F("Aktywuję funkcje sieciowe ... "));
  if (sms.setPhoneFunc(1)) {
    Serial.println(F("gotowe!"));
  } else {
    Serial.println(F("coś poszło nie tak :("));
  }
  delay(1000); 

  // siła sygnału: 0-31 -> 0-słaba, 31-doskonała, 99-nieznana
  Serial.print(F("Sprawdzam siłę sygnału ... "));
  Serial.print(sms.signalQuality());
  Serial.println(F(" [0-31]"));
  delay(1000); 

  // czy moduł jest zarejestrowany u operatora sieci GSM?
  Serial.print(F("Sprawdzam połączenie z operatorem ... "));
  if (sms.isRegistered()) {
    Serial.println(F("aktywne!"));
  } else {
    Serial.println(F("coś poszło nie tak :("));
  }
  delay(1000);

  // nazwa operatora sieci GSM
  Serial.print(F("Operator: "));
  Serial.println(sms.operatorNameFromSim());
  delay(1000);

  // inicjalizacja obsługi wiadomości SMS
  Serial.print(F("Aktywuję obsługę wiadomości SMS ... "));
  if (sms.initSMS()) {
    Serial.println(F("włączona!"));
  } else {
    Serial.println(F("coś poszło nie tak :("));
  }
  delay(1000);

  // wyślij dane do administratora
  if (ADMIN_SEND) {
    Serial.print(F("Wysyłam dane do administratora ... "));
    if (sendSMS(ADMIN_PHONE)) {
      Serial.println(F("gotowe!"));
    } else {
      Serial.println(F("coś poszło nie tak :("));
    }
    delay(1000);
  }

  Serial.println(F("System gotowy do obsługi wiadomości SMS!"));
}

void loop()
{
  unsigned long currentTime = millis();

  // obsługa kolejnego odczytu z czujnika DHT
  if (currentTime - previousTime >= eventTime)
  { 
    previousTime = currentTime;

    float temp = dht.readTemperature();
    float hmd = dht.readHumidity();

    if (!(isnan(temp) || isnan(hmd))) // czy odczyt z czujnika jest prawidłowy?
    {
      Serial.print(F("Odczyt danych z czujnika DHT => T: "));
      Serial.print(temp);
      Serial.print(F("°C, H: "));
      Serial.print(hmd);
      Serial.println(F("%"));

      // jeśli wartości krytyczne zostały przekroczone
      if (temp >= alarmTemp || hmd >= alarmHmd) {
        // wyślij SMS, jeśli od ostatniej wysyłki minęło co najmniej 5 minut
        if (currentTime - previousSMS >= eventSMS)
        {
          previousSMS = currentTime;
          Serial.print(F("Alarm! Wysyłam dane z czujnika DHT ... "));
          sendSMS(ADMIN_PHONE, "Alarm! ");
          Serial.println(F("gotowe!"));
        }
      }
    } 
    else 
    {
      Serial.println(F("Błędny odczyt z czujnika DHT."));
    }
  }

  // obsługa modułu GSM
  if(sim800l.available()) // jeśli pojawią się dane na interfejsie UART
  {
    String buffer = "";
    buffer = sim800l.readString(); // odczytaj dane z bufora
    smsCnt++;                      // zwiększ licznik odebranych komunikatów
    Serial.print(smsCnt);
    Serial.print(". ");

    // czy odebrany komunikat to wiadomość SMS?
    // CMTI wskazuje na lokalizację nowej wiadomości SMS w pamięci
    if(buffer.indexOf("+CMTI:") != -1)
    {      
      Serial.print(F("Numer SMS w indeksie: "));
      int indexno = sms.indexFromSerial(buffer);
      Serial.println(indexno);

      Serial.print(F("Nadawca: "));
      String senderno = sms.getSenderNo(indexno);
      Serial.println(senderno); // pobierz dane za pomocą indeksu

      Serial.print(F("Komunikat: "));
      // Serial.println(sms.readFromSerial(buffer));
      String msg = sms.read(indexno);
      Serial.println(msg);

      // wyodrębnij z bufora treść wiadomości SMS
      // np.: FOLDER:INCOMING|STATUS:UNREAD|PHONENO:*|DATETIME:*|MESSAGE:DHT
      msg = split(msg, '|', 4); // MESSAGE:DHT
      msg = split(msg, ':', 1); // DHT
      msg.toUpperCase();

      Serial.print(F("Wiadomość: "));
      Serial.println(msg);

      if (msg == "DHT") {
        Serial.print(F("Wysyłam dane z czujnika DHT ... "));
        sendSMS(senderno);
        Serial.println(F("gotowe!"));
      }
    } 
    else 
    {
      // komunikat nie będący wiadomością SMS
      Serial.println(buffer);
    }   
  }  
}

// funkcja wysyłająca wiadomość SMS
bool sendSMS(String recipientno, String headerText = "")
{
  float temp = dht.readTemperature();
  float hmd = dht.readHumidity();
  
  if (!(isnan(temp) || isnan(hmd)))
  {
    String msg = headerText;
    msg.concat(F("Dane z czujnika DHT["));
    msg.concat(board_id);
    msg.concat(F("]: Temp: "));
    msg.concat(temp);
    msg.concat(F("C, Hmd: "));
    msg.concat(hmd);
    msg.concat(F("%"));

    // zamień typ String na Char
    int recipientno_len = recipientno.length() + 1;
    char phone[recipientno_len];
    recipientno.toCharArray(phone, recipientno_len);

    int msg_len = msg.length() + 1;
    char text[msg_len];
    msg.toCharArray(text, msg_len);

    if (sms.send(phone, text)) {
      return true;
    } else {
      return false;
    }
  }

  return false;
}

// implementacja funkcji split do podziału tekstu
String split(String data, char separator, int index)
{
  int found = 0;
  int strIndex[] = {0, -1};
  int maxIndex = data.length()-1;

  for(int i=0; i<=maxIndex && found<=index; i++)
  {
    if(data.charAt(i)==separator || i==maxIndex)
    {
      found++;
      strIndex[0] = strIndex[1]+1;
      strIndex[1] = (i == maxIndex) ? i+1 : i;
    }
  }

  return found>index ? data.substring(strIndex[0], strIndex[1]) : "";
}
